<?php

namespace Inside\DESK\Models;

use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $date_sent
 * @property ?string $langcode
 * @property int $sent
 * @property int $viewed
 * @property int $clicked
 * @property int $unique_clicked
 * @method static Builder query()
 * @method static void truncate()
 * @method static bool insert($values)
 */
class NewsletterComputedStatistics extends Model
{
    use WithEnhancedBuilder;

    protected $primaryKey = null;
    public $incrementing = false;

    protected $table = 'desk_newsletters_computed_statistics';

    public $timestamps = false;

    protected $casts = [
        'date_sent' => 'timestamp',
    ];

    protected $fillable = [
        'date_sent',
        'langcode',
        'sent',
        'viewed',
        'clicked',
        'unique_clicked',
    ];
}
