<?php

namespace Inside\DESK\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\DB;
use Inside\Content\Events\ContentInsertedEvent;

/**
 * Send mails when a new alert is created.
 *
 * @category Class
 * @package  Inside\DESK\Listeners\ContentInsertedListener
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentInsertedListener implements ShouldQueue
{
    public function handle(ContentInsertedEvent $event): void
    {
        $model = $event->model;

        if ($model->content_type !== 'alerts') {
            return;
        }

        DB::table('desk_alerts_to_send')->insert([
            'uuid' => $model->uuid,
        ]);
    }
}
