<?php

namespace Inside\DESK\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\CommentDeletedEvent;
use Inside\Content\Models\Contents\Comments;
use Inside\Host\Bridge\BridgeContent;

/**
 * Send mails when a new alert is created.
 *
 * @category Class
 * @package  Inside\DESK\Listeners\CommentDeletedListener
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class CommentDeletedListener implements ShouldQueue
{
    public function handle(CommentDeletedEvent $event): void
    {
        $uuid = $event->comment;

        $bridge = new BridgeContent();

        Comments::where('uuid_source', $uuid['uuid_source'])->each(function ($comment) use ($bridge) {
            $bridge->contentDelete('comments', $comment->uuid);
        });
    }
}
