<?php

namespace Inside\DESK\Listeners;

use Illuminate\Support\Facades\DB;
use Inside\Authentication\Events\AuthenticationLoginEvent;

/**
 * Reset alert reaction when a user logs in
 *
 * @category Class
 * @package  Inside\DESK\Listeners\AuthenticationLoginListener
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AuthenticationLoginListener
{
    public function handle(AuthenticationLoginEvent $event): void
    {
        DB::table('inside_reactions')->where('type', 'alert')->where('user_uuid', $event->user->uuid)->where('created_at', 'LIKE', date('Y-m-d', time()) . ' %')->delete();
    }
}
