<?php

namespace Inside\DESK\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Inside\Host\Bridge\BridgeContent;

/**
 * Class UpdateUserTools
 *
 * @category Class
 * @package  Inside\DESK\Jobs\UpdateUserTools
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UpdateUserTools implements ShouldQueue
{
    use InteractsWithQueue;
    use Queueable;

    /**
     * @var array
     */
    protected $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    /**
     *
     */
    public function handle(): void
    {
        $bridge = new BridgeContent();

        $bridge->contentUpdate('users', $this->data);
    }
}
