<?php

namespace Inside\DESK\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Model;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

/**
 * Class SendStatisticsExportNotification
 *
 * @category Class
 * @package  Inside\DESK\Jobs\SendStatisticsExportNotification
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SendStatisticsExportNotification extends BaseNotificationListener implements ShouldQueue
{
    use InteractsWithQueue;
    use Queueable;

    /**
     * @var User
     */
    protected $user;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $url;

    public function __construct(Users $user, string $title, string $url)
    {
        /** @var User $user */
        $user = User::query()->find($user->uuid);

        $this->user = $user;
        $this->title = $title;
        $this->url = $url;
    }

    /**
     *
     */
    public function handle(): void
    {
        /** @var NotificationType $type */
        $type = NotificationType::query()->where('type', 'system')->where('action', 'statistics_exported')->first();

        $this->route = $this->user;
        $this->notify($type, $this->user, null, ['title' => $this->title, 'extra' => ['link' => $this->url]]);
    }
}
