<?php

declare(strict_types=1);

namespace Inside\DESK\Exports;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Str;

class NewsletterViewsDeskStatisticsExport extends AbstractDeskStatisticsExport
{
    public function __construct(
        private int $newsletterDate,
        private ?string $search = null,
        private array $filters = [],
        private ?string $langcode = 'en'
    ) {
        parent::__construct();
    }

    public function query(): Builder
    {
        return $this->deskStatistics->getNewsletterViewsQuery(
            $this->newsletterDate,
            $this->search,
            $this->filters,
        );
    }

    public function headings(): array
    {
        if ($this->langcode) {
            Lang::setLocale($this->langcode);
        }

        return [
            Lang::get("desk.statistics.views.cols.email"),
            Lang::get("desk.statistics.views.cols.full_name"),
            Lang::get("desk.statistics.views.cols.fra_code"),
        ];
    }

    public function map($row): array
    {
        return [
            $row->email,
            trim(Str::title($row->firstname).' '.Str::upper($row->lastname)) ?: '-',
            $row->fra_code,
        ];
    }
}
