<?php

namespace Inside\DESK\Exports;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\App;
use Inside\DESK\Contracts\DeskStatistics;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithCustomCsvSettings;
use Maatwebsite\Excel\Concerns\WithCustomQuerySize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

abstract class AbstractDeskStatisticsExport implements
    FromQuery,
    WithMapping,
    ShouldQueue,
    ShouldAutoSize,
    WithCustomCsvSettings,
    WithHeadings,
    WithCustomQuerySize,
    WithColumnFormatting
{
    use Exportable;

    protected DeskStatistics $deskStatistics;

    public function __construct()
    {
        $this->deskStatistics = App::make(DeskStatistics::class);
    }


    public function getCsvSettings(): array
    {
        return [
            'delimiter' => ',',
            'enclosure' => '"',
            'line_ending' => PHP_EOL,
            'use_bom' => true,
            'include_separator_line' => false,
            'excel_compatibility' => false,
        ];
    }

    public function querySize(): int
    {
        return $this->deskStatistics->getQueryCount($this->query());
    }

    abstract public function query(): Builder;

    public function columnFormats(): array
    {
        return [];
    }
}
