<?php

declare(strict_types=1);

namespace Inside\DESK\Contracts;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Contracts\Pagination\Paginator;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;

interface DeskStatistics
{
    public function getAlertsStatistics(?string $search = null, array $filters = []): Paginator | Collection | LengthAwarePaginator | array;

    public function getAlertsStatisticsQuery(?string $search = null, array $filters = []): Builder;

    public function getNewslettersStatistics(array $filters = []): Paginator | Collection | LengthAwarePaginator | array;

    public function getNewslettersStatisticsQuery(array $filters = []): Builder;

    public function getQueryCount(Builder $query): int;

    public function getNewsletterViewsQuery(int $newsletterDate, ?string $search = null, array $filters = []): Builder;

    public function getNewsletterViews(int $newsletterDate, ?string $search = null, array $filters = []): Paginator | Collection | LengthAwarePaginator | array;

    public function getAlertViewsQuery(string $alertUuid, ?string $search = null, array $filters = []): Builder;

    public function getAlertViews(string $alertUuid, ?string $search = null, array $filters = []): Paginator | Collection | LengthAwarePaginator | array;
}
