@php ($assetPath    = '/themes/custom/inside-drupal-theme/assets')
@php ($documentRoot = filter_input(INPUT_SERVER, 'DOCUMENT_ROOT', FILTER_SANITIZE_STRING))
@php ($buildTime    = file_exists($documentRoot . $assetPath) ? filemtime($documentRoot . $assetPath) ?? 0 : 0)
<!DOCTYPE html>
@if (\Auth::user())
<html lang={{ \Auth::user()->langcode }} dir=ltr>
@else
<html lang={{ env('APP_LOCALE', 'en')}} dir=ltr>
@endif
  <head>
      @if (!empty(env('LHG_COOKIELAW_KEY', false)))
          <!-- OneTrust Cookies Consent Notice start for www.ledesk.louvrehotels.com -->
          <script src="https://cdn.cookielaw.org/scripttemplates/otSDKStub.js"  type="text/javascript" charset="UTF-8" data-domain-script="{{ env('LHG_COOKIELAW_KEY') }}" ></script>
          <script type="text/javascript">
              function OptanonWrapper() { }
          </script>
          <!-- OneTrust Cookies Consent Notice end for www.ledesk.louvrehotels.com -->
      @endif

    <meta charset=utf-8>
    <meta name=viewport content="width=device-width,user-scalable=yes,initial-scale=1.0,maximum-scale=5.0">
    <meta name=HandheldFriendly content=true>

    <meta name=application-name content="{{ env('APP_NAME') }}">
    <meta name=mobile-web-app-capable content=yes>
    <meta name=theme-color content="{{ env('WEBAPP_COLOR', '#fbb3a7') }}">

    <meta name=apple-mobile-web-app-capable content=yes />
    <meta name=apple-mobile-web-app-title content="{{ env('APP_NAME') }}">
    <meta name=apple-mobile-web-app-status-bar-style content=#ffffff>

    <meta http-equiv=X-UA-Compatible content="IE=edge">
    <meta name=format-detection" content="telephone=no">

    <meta name=msapplication-config content="{{ $assetPath }}/assets/browserconfig.xml" />
    <meta name=msapplication-TileColor content="{{ env('WEBAPP_COLOR', '#fbb3a7') }}">
    <meta name=msapplication-TileImage content="{{ $assetPath }}/assets/img/app-logo/mstile-144x144.png">

    <meta name=robots content=noindex>
    <meta name=description content="{{ env('APP_NAME') }}">

    <title>{{ env('APP_NAME') }}</title>

    <link rel="shortcut icon" href="{{ $assetPath }}/favicon.ico?t={{ $buildTime }}" type="image/x-icon" />

    <link rel="icon" type="image/png" sizes="192x192" href="{{ $assetPath }}/img/app-logo/android-chrome-192x192.png?t={{ $buildTime }}">

    <link rel="icon" type="image/png" sizes="16x16" href="{{ $assetPath }}/img/app-logo/android-chrome-16x16.png?t={{ $buildTime }}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{ $assetPath }}/img/app-logo/android-chrome-32x32.png?t={{ $buildTime }}">
    <link rel="icon" type="image/png" sizes="194x194" href="{{ $assetPath }}/img/app-logo/android-chrome-194x194.png?t={{ $buildTime }}">

    <link rel="apple-touch-icon" href="{{ $assetPath }}/img/app-logo/apple-touch-icon.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-precomposed.png?t={{ $buildTime }}">

    <link rel="apple-touch-icon" sizes="57x57" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-57x57.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="60x60" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-60x60.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="72x72" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-72x72.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="76x76" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-76x76.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="114x114" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-114x114.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="120x120" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-120x120.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="144x144" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-144x144.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="152x152" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-152x152.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-180x180.png?t={{ $buildTime }}">

    <link rel="apple-touch-icon-precomposed" sizes="57x57" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-57x57-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="60x60" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-60x60-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-72x72-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="76x76" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-76x76-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-114x114-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="120x120" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-120x120-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-144x144-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="152x152" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-152x152-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="180x180" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-180x180-precomposed.png?t={{ $buildTime }}">

    <link rel="apple-touch-startup-image" sizes="320x460" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-320x460.png?t={{ $buildTime }}" media="(device-width: 320px) and (-webkit-device-pixel-ratio: 1)">
    <link rel="apple-touch-startup-image" sizes="768x1004" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-768x1004.png?t={{ $buildTime }}" media="(device-width: 768px) and (-webkit-device-pixel-ratio: 1) and (orientation: portrait)">
    <link rel="apple-touch-startup-image" sizes="748x1024" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-748x1024.png?t={{ $buildTime }}" media="(device-width: 768px) and (-webkit-device-pixel-ratio: 1) and (orientation: landscape)">
    <link rel="apple-touch-startup-image" sizes="640x920" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-640x920.png?t={{ $buildTime }}" media="(device-width: 320px) and (-webkit-device-pixel-ratio: 2)">
    <link rel="apple-touch-startup-image" sizes="750x1334" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-750x1334.png?t={{ $buildTime }}" media="(device-width: 375px) and (-webkit-device-pixel-ratio: 2)">
    <link rel="apple-touch-startup-image" sizes="1536x2008" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-1536x2008.png?t={{ $buildTime }}" media="(device-width: 768px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)">
    <link rel="apple-touch-startup-image" sizes="2048x1496" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-2048x1496.png?t={{ $buildTime }}" media="(device-width: 768px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)">
    <link rel="apple-touch-startup-image" sizes="1242x2208" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-1242x2208.png?t={{ $buildTime }}" media="(device-width: 414px) and (-webkit-device-pixel-ratio: 3)">
    <link rel="apple-touch-startup-image" sizes="1242x2148" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-1242x2208.png?t={{ $buildTime }}" media="(device-width: 414px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)">
    <link rel="apple-touch-startup-image" sizes="1182x2208" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-1242x2208.png?t={{ $buildTime }}" media="(device-width: 414px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)">

    <link rel="mask-icon" href="{{ $assetPath }}/img/app-logo/safari-pinned-tab.svg?t={{ $buildTime }}" color="{{ env('WEBAPP_COLOR', '#fbb3a7') }}">

      <script type="text/javascript">
          if (window.document.documentMode && window.location.href.indexOf('/login') <= 0) {
              window.location.href = '/internet-explorer'
          }
      </script>

      {!! Inside::css() !!}
      {!! Inside::headerJs() !!}
  </head>
  <body>
    <div id=app></div>
    {!! Inside::script() !!}
    {!! Inside::js() !!}
  </body>
</html>
