@php
    use Carbon\Carbon;
    use Illuminate\Support\Str;

    // Force language
     \Illuminate\Support\Facades\Lang::setLocale($locale);
    setlocale(LC_TIME, $locale, $time);
    Carbon::setLocale($locale);
    Carbon::setUtf8(false);

    $dateFormat = $locale === 'fr' ? '%d %B %Y' : '%B %d, %Y';
@endphp
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"
      style="width:100%;font-family:arial, 'helvetica neue', helvetica, sans-serif;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;padding:0;Margin:0">
<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1" name="viewport">
    <meta name="x-apple-disable-message-reformatting">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="telephone=no" name="format-detection">
    <img src="{{ $trackingPixelUrl }}">
    <title>Newsletter</title>
    <!--[if (mso 16)]>
    <style type="text/css">
        a {
            text-decoration: none;
        }
    </style>
    <![endif]-->
    <!--[if gte mso 9]>
    <style>sup {
        font-size: 100% !important;
    }</style><![endif]-->
    <!--[if gte mso 9]>
    <xml>
        <o:OfficeDocumentSettings>
            <o:AllowPNG></o:AllowPNG>
            <o:PixelsPerInch>96</o:PixelsPerInch>
        </o:OfficeDocumentSettings>
    </xml>
    <![endif]-->
    <style type="text/css">
        @media only screen and (max-width: 700px) {
            p, ul li, ol li, a {
                font-size: 16px !important
            }

            h1 {
                font-size: 30px !important;
                text-align: center
            }

            h2 {
                font-size: 26px !important;
                text-align: center
            }

            h3 {
                font-size: 20px !important;
                text-align: center
            }

            h1 a {
                font-size: 30px !important
            }

            h2 a {
                font-size: 26px !important
            }

            h3 a {
                font-size: 20px !important
            }

            .es-menu td a {
                font-size: 16px !important
            }

            .es-header-body p, .es-header-body ul li, .es-header-body ol li, .es-header-body a {
                font-size: 16px !important
            }

            .es-footer-body p, .es-footer-body ul li, .es-footer-body ol li, .es-footer-body a {
                font-size: 16px !important
            }

            .es-infoblock p, .es-infoblock ul li, .es-infoblock ol li, .es-infoblock a {
                font-size: 12px !important
            }

            *[class="gmail-fix"] {
                display: none !important
            }

            .es-m-txt-c, .es-m-txt-c h1, .es-m-txt-c h2, .es-m-txt-c h3 {
                text-align: center !important
            }

            .es-m-txt-r, .es-m-txt-r h1, .es-m-txt-r h2, .es-m-txt-r h3 {
                text-align: right !important
            }

            .es-m-txt-l, .es-m-txt-l h1, .es-m-txt-l h2, .es-m-txt-l h3 {
                text-align: left !important
            }

            .es-m-txt-r img, .es-m-txt-c img, .es-m-txt-l img {
                display: inline !important
            }

            .es-button-border {
                display: block !important
            }

            .es-button {
                font-size: 20px !important;
                display: block !important;
                border-width: 10px 0px 10px 0px !important
            }

            .es-btn-fw {
                border-width: 10px 0px !important;
                text-align: center !important
            }

            .es-adaptive table, .es-btn-fw, .es-btn-fw-brdr, .es-left, .es-right {
                width: 100% !important
            }

            .es-content table, .es-header table, .es-footer table, .es-content, .es-footer, .es-header {
                width: 100% !important;
                max-width: 700px !important
            }

            .es-adapt-td {
                display: block !important;
                width: 100% !important
            }

            .adapt-img {
                width: 100% !important;
                height: auto !important
            }

            .es-m-p0 {
                padding: 0px !important
            }

            .es-m-p0r {
                padding-right: 0px !important
            }

            .es-m-p0l {
                padding-left: 0px !important
            }

            .es-m-p0t {
                padding-top: 0px !important
            }

            .es-m-p0b {
                padding-bottom: 0 !important
            }

            .es-m-p20b {
                padding-bottom: 20px !important
            }

            .es-mobile-hidden, .es-hidden {
                display: none !important
            }

            tr.es-desk-hidden, td.es-desk-hidden, table.es-desk-hidden {
                display: table-row !important;
                width: auto !important;
                overflow: visible !important;
                float: none !important;
                max-height: inherit !important;
                line-height: inherit !important
            }

            .es-desk-menu-hidden {
                display: table-cell !important
            }

            table.es-table-not-adapt, .esd-block-html table {
                width: auto !important
            }

            table.es-social {
                display: inline-block !important
            }

            table.es-social td {
                display: inline-block !important
            }
        }

        #outlook a {
            padding: 0;
        }

        .ExternalClass {
            width: 100%;
        }

        .ExternalClass,
        .ExternalClass p,
        .ExternalClass span,
        .ExternalClass font,
        .ExternalClass td,
        .ExternalClass div {
            line-height: 100%;
        }

        .es-button {
            mso-style-priority: 100 !important;
            text-decoration: none !important;
        }

        a[x-apple-data-detectors] {
            color: inherit !important;
            text-decoration: none !important;
            font-size: inherit !important;
            font-family: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
        }

        .es-desk-hidden {
            display: none;
            float: left;
            overflow: hidden;
            width: 0;
            max-height: 0;
            line-height: 0;
            mso-hide: all;
        }
    </style>
</head>
<body
    style="width:100%;font-family:arial, 'helvetica neue', helvetica, sans-serif;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;padding:0;Margin:0">
<div class="es-wrapper-color" style="background-color:#F6F6F6">
    <!--[if gte mso 9]>
    <v:background xmlns:v="urn:schemas-microsoft-com:vml" fill="t">
        <v:fill type="tile" color="#f6f6f6"></v:fill>
    </v:background>
    <![endif]-->
    <table class="es-wrapper" width="100%" cellspacing="0" cellpadding="0"
           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;padding:0;Margin:0;width:100%;height:100%;background-repeat:repeat;background-position:center top">
        <tr style="border-collapse:collapse">
            <td valign="top" style="padding:0;Margin:0">
                <!-- begin header -->
                <table class="es-content" cellspacing="0" cellpadding="0" align="center"
                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
                    <tr style="border-collapse:collapse">
                        <td align="center" style="padding:0;Margin:0">
                            <table class="es-content-body"
                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:transparent;width:700px"
                                   cellspacing="0" cellpadding="0" align="center">
                                <tr style="border-collapse:collapse">
                                    <td align="left" style="padding:0;Margin:0">
                                        <table width="100%" cellspacing="0" cellpadding="0"
                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                            <tr style="border-collapse:collapse">
                                                <td valign="top" align="center" style="padding:0;Margin:0;width:700px">
                                                    <table width="100%" cellspacing="0" cellpadding="0"
                                                           role="presentation"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                        <tr style="border-collapse:collapse">
                                                            <td align="center" style="padding:0;Margin:0;font-size:0px">
                                                                <img class="adapt-img"
                                                                     src="{{ env('APP_URL') }}/vendor/maecia/desk-back/resources/assets/img/newsletter/{{ $locale }}/header.png"
                                                                     alt
                                                                     style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic"
                                                                     width="700"></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <!-- end header -->
                <!-- begin intro -->
                <table class="es-content" cellspacing="0" cellpadding="0" align="center"
                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
                    <tr style="border-collapse:collapse">
                        <td align="center" style="padding:0;Margin:0">
                            <table class="es-content-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff"
                                   align="center"
                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:700px">
                                <tr style="border-collapse:collapse">
                                    <td class="esdev-adapt-off" align="left"
                                        style="padding:0;Margin:0;padding-bottom:25px">
                                        <table cellpadding="0" cellspacing="0" class="esdev-mso-table"
                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;width:700px">
                                            <tr style="border-collapse:collapse">
                                                <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                    <table cellspacing="0" cellpadding="0" align="left" class="es-left"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                        <tr style="border-collapse:collapse">
                                                            <td valign="top" align="center"
                                                                style="padding:0;Margin:0;width:87px">
                                                                <table width="100%" cellspacing="0" cellpadding="0"
                                                                       role="presentation"
                                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                    <tr style="border-collapse:collapse">
                                                                        <td align="left" style="padding:0;Margin:0"><p
                                                                                style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333">
                                                                                <br></p></td>
                                                                    </tr>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                    <table cellpadding="0" cellspacing="0" class="es-left" align="left"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                        <tr style="border-collapse:collapse">
                                                            <td align="left"
                                                                style="padding:0 40px;Margin:0;width:526px">
                                                                <table cellpadding="0" cellspacing="0" width="100%"
                                                                       role="presentation"
                                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                    <tr style="border-collapse:collapse">
                                                                        <td align="center"
                                                                            style="top: -30px;position: relative;height:0;padding:0;Margin:0">
                                                                            <p style="text-align: center; Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#909090">
                                                                                {{ ucfirst(Carbon::createFromTimestamp($startDate)->formatLocalized($dateFormat)) }}</p></td>
                                                                    </tr>
                                                                    <tr style="border-collapse:collapse">
                                                                        <td align="left" style="padding:0;Margin:0">
                                                                            <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#2C3E50";word-break:break-word;>{!! \Illuminate\Support\Facades\Lang::getFromJson('desk.newsletter.intro', [], $locale) !!}</p>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                    <table cellpadding="0" cellspacing="0" class="es-right"
                                                           align="right"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                        <tr style="border-collapse:collapse">
                                                            <td align="left" style="padding:0;Margin:0;width:87px">
                                                                <table cellpadding="0" cellspacing="0" width="100%"
                                                                       role="presentation"
                                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                    <tr style="border-collapse:collapse">
                                                                        <td align="left" style="padding:0;Margin:0">
                                                                            <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333">

                                                                                <br></p></td>
                                                                    </tr>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <!-- end intro -->
                <!-- begin news -->
                @foreach($categories as $category)
                    @if (!empty($category['contents']))
                        <table class="es-content" cellspacing="0" cellpadding="0" align="center"
                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
                            <tr style="border-collapse:collapse">
                                <td align="center" style="padding:0;Margin:0">
                                    <table class="es-content-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff"
                                           align="center"
                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:700px">
                                        <tr style="border-collapse:collapse">
                                            <td class="esdev-adapt-off" align="left"
                                                style="padding:0;Margin:0;padding-top:5px;padding-bottom:5px">
                                                <table cellpadding="0" cellspacing="0" class="esdev-mso-table"
                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;width:700px">
                                                    <tr style="border-collapse:collapse">
                                                        <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                            <table cellspacing="0" cellpadding="0" align="left" class="es-left"
                                                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                                <tr class="es-mobile-hidden" style="border-collapse:collapse">
                                                                    <td valign="top" align="center"
                                                                        style="padding:0;Margin:0;width:77px">
                                                                        <table width="100%" cellspacing="0" cellpadding="0"
                                                                               bgcolor="transparent"
                                                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:transparent"
                                                                               role="presentation">
                                                                            <tr class="es-mobile-hidden"
                                                                                style="border-collapse:collapse">
                                                                                <td align="left" style="padding:0;Margin:0"><p
                                                                                        style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333">
                                                                                        <br></p></td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                    <td style="padding:0;Margin:0;width:10px"></td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                        <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                            <table cellpadding="0" cellspacing="0" class="es-left" align="left"
                                                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                                <tr style="border-collapse:collapse">
                                                                    <td align="left"
                                                                        style="padding:0 40px;Margin:0;width:526px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%"
                                                                               role="presentation"
                                                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tr style="border-collapse:collapse">
                                                                                <td align="left"
                                                                                    style="Margin:0;padding-bottom:5px;padding-left:5px;padding-right:5px;padding-top:0">
                                                                                    <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#2C3E50">{{ \Illuminate\Support\Str::upper($category['title']) }}</p></td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                    <td style="padding:0;Margin:0;width:10px"></td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                        <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                            <table cellpadding="0" cellspacing="0" class="es-right"
                                                                   align="right"
                                                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                                <tr class="es-mobile-hidden" style="border-collapse:collapse">
                                                                    <td align="left" style="padding:0;Margin:0;width:77px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%"
                                                                               role="presentation"
                                                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tr class="es-mobile-hidden"
                                                                                style="border-collapse:collapse">
                                                                                <td align="left" style="padding:0;Margin:0"><p
                                                                                        style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333">
                                                                                        <br></p></td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <!-- begin one news -->
                                        @foreach($category['contents'] as $content)
                                        <tr style="border-collapse:collapse">
                                            <td align="left" style="padding:0;Margin:0;padding-top:10px;padding-bottom:20px">
                                                <!--[if mso]>
                                                <table style="width:700px" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td style="width:87px" valign="top"><![endif]-->
                                                <table class="es-left" cellspacing="0" cellpadding="0" align="left"
                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                    <tr class="es-mobile-hidden" style="border-collapse:collapse">
                                                        <td class="es-m-p20b" align="left"
                                                            style="padding:0;Margin:0;width:80px">
                                                            <table width="100%" cellspacing="0" cellpadding="0"
                                                                   role="presentation"
                                                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                <tr style="border-collapse:collapse">
                                                                    <td align="left" style="padding:0;Margin:0"><p
                                                                            style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#000000">
                                                                            <br></p></td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                        <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                    </tr>
                                                </table>
                                                <!--[if mso]></td>
                                                <td style="width:167px" valign="top"><![endif]-->
                                                <table class="es-left" cellspacing="0" cellpadding="0" align="left"
                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                    <tr style="border-collapse:collapse">
                                                        <td class="es-hidden" style="padding:0;Margin:0;width:35px"></td>
                                                        <td class="es-m-p20b" align="left"
                                                            style="padding:0;Margin:0;width:147px">
                                                            <table width="100%" cellspacing="0" cellpadding="0"
                                                                   role="presentation"
                                                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                <tr style="border-collapse:collapse">
                                                                    <td align="center" style="padding:0;Margin:0;font-size:0px">
                                                                        <a target="_blank" href="{{ $content['slug'] }}"
                                                                           style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, 'helvetica neue', helvetica, sans-serif;font-size:14px;text-decoration:none;color:#1F4D8B"><img
                                                                                class="adapt-img"
                                                                                src="{{ url('notify_content_files', [$content['type'], $content['uuid']]) }}" alt
                                                                                style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic"
                                                                                width="147"></a></td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                        <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                    </tr>
                                                </table>
                                                <!--[if mso]></td>
                                                <td style="width:265px" valign="top"><![endif]-->
                                                <table class="es-left" cellspacing="0" cellpadding="0" align="left"
                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                    <tr style="border-collapse:collapse">
                                                        <td class="es-m-p20b" align="left"
                                                            style="padding:0;Margin:0;width:300px">
                                                            <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                <tr style="border-collapse:collapse">
                                                                    <td align="left" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#A7A7A7">
                                                                            {{ Carbon::createFromTimestamp($content['timestamp'])->formatLocalized($dateFormat) }}</p></td>
                                                                </tr>
                                                                <tr style="border-collapse:collapse">
                                                                    <td align="left" style="padding:0;Margin:0;padding-top:5px">
                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:17px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:20px;color:#2C3E50">
                                                                            <strong>
                                                                                <a target="_blank" href="{{ $content['slug'] }}" style="text-decoration:none; color:#2C3E50;">
                                                                                    {{ $content['title'] }}
                                                                                </a>
                                                                            </strong><br></p></td>
                                                                </tr>
                                                                <tr style="border-collapse:collapse">
                                                                    <td style="padding:0;Margin:0">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" class="es-menu" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tr class="images" style="border-collapse:collapse">
                                                                                <td align="left" valign="top" width="33.33%" id="esd-menu-id-0" style="Margin:0;padding-left:0px;padding-right:0px;padding-top:10px;padding-bottom:10px;border:0">
                                                                                    @php
                                                                                        foreach ($content['brands'] as $brand) {
                                                                                            echo '<img src="' . url('notify_content_files', ['brands', $brand['uuid']]) . '"
                                                                                         alt="' . $brand['title'] . '" title="' . $brand['title'] .'" height="16"
                                                                                         style="margin:0 5px;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic">';
                                                                                        }
                                                                                    @endphp
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                                <!--[if mso]></td>
                                                <td style="width:20px"></td>
                                                <td style="width:80px" valign="top"><![endif]-->
                                                <table cellpadding="0" cellspacing="0" class="es-right" align="right"
                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                    <tr class="es-mobile-hidden" style="border-collapse:collapse">
                                                        <td align="left" style="padding:0;Margin:0;width:80px">
                                                            <table cellpadding="0" cellspacing="0" width="100%"
                                                                   role="presentation"
                                                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                <tr style="border-collapse:collapse">
                                                                    <td align="left" style="padding:0;Margin:0"><p
                                                                            style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333">
                                                                            <br></p></td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                                <!--[if mso]></td></tr></table><![endif]--></td>
                                        </tr>
                                        @endforeach
                                        <!-- end one news -->
                                    </table>
                                </td>
                            </tr>
                        </table>
                    @endif
                @endforeach
                <!-- end news -->
                <!-- see all news -->
                <table class="es-content" cellspacing="0" cellpadding="0" align="center"
                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
                    <tr style="border-collapse:collapse">
                        <td align="center" style="padding:0;Margin:0">
                            <table class="es-content-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff"
                                   align="center"
                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:700px">
                                <tr style="border-collapse:collapse">
                                    <td class="esdev-adapt-off" align="left"
                                        style="Margin:0;padding-top:10px;padding-left:20px;padding-bottom:30px;padding-right:40px">
                                        <table cellpadding="0" cellspacing="0" class="esdev-mso-table"
                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;width:540px">
                                            <tr style="border-collapse:collapse">
                                                <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                    <table class="es-left" cellspacing="0" cellpadding="0" align="left"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                        <tr class="es-mobile-hidden" style="border-collapse:collapse">
                                                            <td align="left" style="padding:0;Margin:0;width:250px">
                                                                <table width="100%" cellspacing="0" cellpadding="0"
                                                                       role="presentation"
                                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                    <tr class="es-mobile-hidden"
                                                                        style="border-collapse:collapse">
                                                                        <td align="left" style="padding:0;Margin:0"><p
                                                                                style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333">
                                                                                <br></p></td>
                                                                    </tr>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                    <table class="es-left" cellspacing="0" cellpadding="0" align="left"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                        <tr style="border-collapse:collapse">
                                                            <td align="left" style="padding:0;Margin:0;width:15px">
                                                                <table width="100%" cellspacing="0" cellpadding="0"
                                                                       role="presentation"
                                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                    <tr style="border-collapse:collapse">
                                                                        <td class="es-m-txt-c" align="right"
                                                                            style="padding:0;Margin:0;padding-top:5px;font-size:0px">
                                                                            <img src="{{ env('APP_URL') }}/vendor/maecia/desk-back/resources/assets/img/newsletter/arrow.png" alt
                                                                                 style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic"
                                                                                 width="13"></td>
                                                                    </tr>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                    <table class="es-left" cellspacing="0" cellpadding="0" align="left"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                        <tr style="border-collapse:collapse">
                                                            <td align="left" style="padding:0;Margin:0;width:170px">
                                                                <table width="100%" cellspacing="0" cellpadding="0"
                                                                       role="presentation"
                                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                    <tr style="border-collapse:collapse">
                                                                        <td align="left"
                                                                            style="padding:0;Margin:0;padding-left:10px">
                                                                            <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#507084">
                                                                                <a href="{{ $trackingClickNewsRedirectUrl }}"
                                                                                   style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, 'helvetica neue', helvetica, sans-serif;font-size:14px;text-decoration:none;color:#507084">{{ \Illuminate\Support\Facades\Lang::getFromJson('desk.newsletter.see_all_news', [], $locale) }}</a></p></td>
                                                                    </tr>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="esdev-mso-td" valign="top" style="padding:0;Margin:0">
                                                    <table cellpadding="0" cellspacing="0" class="es-right"
                                                           align="right"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                        <tr class="es-mobile-hidden" style="border-collapse:collapse">
                                                            <td align="left" style="padding:0;Margin:0;width:50px">
                                                                <table cellpadding="0" cellspacing="0" width="100%"
                                                                       role="presentation"
                                                                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                    <tr style="border-collapse:collapse">
                                                                        <td align="left" style="padding:0;Margin:0"><p
                                                                                style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333">
                                                                                <br></p></td>
                                                                    </tr>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <!-- end see all news -->
                <table cellpadding="0" cellspacing="0" class="es-content" align="center"
                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
                    <tr style="border-collapse:collapse">
                        <td align="center" style="padding:0;Margin:0">
                            <table bgcolor="#ffffff" class="es-content-body" align="center" cellpadding="0"
                                   cellspacing="0"
                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:700px">
                                <tr style="border-collapse:collapse">
                                    <td align="left"
                                        style="Margin:0;padding-left:20px;padding-right:20px;padding-top:25px;padding-bottom:25px;background-color:#2C3E50"
                                        bgcolor="#2C3E50">
                                        <!--[if mso]>
                                        <table style="width:560px" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td style="width:97px" valign="top"><![endif]-->
                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left"
                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                            <tr style="border-collapse:collapse">
                                                <td class="es-m-p0r es-m-p20b" align="center"
                                                    style="padding:0;Margin:0;width:77px">
                                                    <table cellpadding="0" cellspacing="0" width="100%"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-position:left top"
                                                           role="presentation">
                                                        <tr class="es-mobile-hidden" style="border-collapse:collapse">
                                                            <td align="left" style="padding:0;Margin:0"><p
                                                                    style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333">
                                                                    <br></p></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                            </tr>
                                        </table>
                                        <!--[if mso]></td>
                                        <td style="width:291px" valign="top"><![endif]-->
                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left"
                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                            <tr style="border-collapse:collapse">
                                                <td class="es-m-p20b" align="center"
                                                    style="padding:0;Margin:0;width:271px">
                                                    <table cellpadding="0" cellspacing="0" width="100%"
                                                           role="presentation"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                        <tr style="border-collapse:collapse">
                                                            <td style="padding:0;padding-left:30px;Margin:0;font-size:0px">
                                                                <img class="adapt-img"
                                                                     src="{{ env('APP_URL') }}/vendor/maecia/desk-back/resources/assets/img/newsletter/logo.png" alt
                                                                     style="margin-top:5px;display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic"
                                                                     width="130"></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                            </tr>
                                        </table>
                                        <!--[if mso]></td>
                                        <td style="width:174px" valign="top"><![endif]-->
                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left"
                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                            <tr style="border-collapse:collapse">
                                                <td align="center" class="es-m-p20b"
                                                    style="padding:0;Margin:0;width:174px">
                                                    <table cellpadding="0" cellspacing="0" width="100%"
                                                           role="presentation"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                        <tr style="border-collapse:collapse">
                                                            <td align="center" style="Margin:0"><span
                                                                    class="es-button-border"
                                                                    style="border-style:solid;border-color:#FFFFFF;background:#2C3E50;border-width:1px;display:inline-block;border-radius:30px;width:auto"><a
                                                                        href="{{ $trackingClickUrl }}" class="es-button" target="_blank"
                                                                        style="mso-style-priority:100 !important;text-decoration:none;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, 'helvetica neue', helvetica, sans-serif;font-size:14px;color:#FFFFFF;border-style:solid;border-color:#2C3E50;border-width:10px 20px 10px 20px;display:inline-block;background:#2C3E50;border-radius:30px;font-weight:normal;font-style:normal;line-height:17px;width:auto;text-align:center;"><img
                                                                            src="{{ env('APP_URL') }}/vendor/maecia/desk-back/resources/assets/img/newsletter/arrow-white.png" alt=""
                                                                            style="margin-right:5px;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic"
                                                                            width="13"
                                                                            class="__web-inspector-hide-shortcut__">{{ \Illuminate\Support\Facades\Lang::getFromJson('desk.newsletter.access_desk', [], $locale) }}</a></span>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                        <!--[if mso]></td>
                                        <td style="width:20px"></td>
                                        <td style="width:77px" valign="top"><![endif]-->
                                        <table cellpadding="0" cellspacing="0" class="es-right" align="right"
                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                            <tr style="border-collapse:collapse">
                                                <td align="left" style="padding:0;Margin:0;width:77px">
                                                    <table cellpadding="0" cellspacing="0" width="100%"
                                                           role="presentation"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                        <tr class="es-mobile-hidden" style="border-collapse:collapse">
                                                            <td align="left" style="padding:0;Margin:0"><p
                                                                    style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333">
                                                                    <br></p></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                        <!--[if mso]></td></tr></table><![endif]--></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <table class="es-content" cellspacing="0" cellpadding="0" align="center"
                       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
                    <tr style="border-collapse:collapse">
                        <td align="center" style="padding:0;Margin:0">
                            <table class="es-content-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff"
                                   align="center"
                                   style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:700px">
                                <tr style="border-collapse:collapse">
                                    <td style="Margin:0;padding-top:20px;padding-bottom:20px;padding-left:110px;padding-right:110px;background-color:#F0F0F0"
                                        bgcolor="#f0f0f0" align="left">
                                        <table width="100%" cellspacing="0" cellpadding="0"
                                               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                            <tr style="border-collapse:collapse">
                                                <td valign="top" align="center" style="padding:0;Margin:0;width:520px">
                                                    <table width="100%" cellspacing="0" cellpadding="0"
                                                           role="presentation"
                                                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                        <tr style="border-collapse:collapse">
                                                            <td align="center" style="padding:0;Margin:0"><p
                                                                    style="text-align:center;Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:10px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:15px;color:#757575">
                                                                    {!! \Illuminate\Support\Facades\Lang::getFromJson('desk.newsletter.footer', ['policy-link' => env('APP_URL') . '/politique-de-confidentialite-du-desk' . ($locale === 'en' ? '-1' : '')], $locale) !!}
                                                                </p></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</div>
</body>
</html>
