<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateTaskCardsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('task_cards');
        $this->finishUp();

        Artisan::call('models:rebuild');

        $task = type_to_class('task_cards')::where([
            "title" => 'Tâches',
            "introduction" => 'Les tâches recommandées par votre RR',
            'langcode' => 'fr'
        ])->first();

        if ($task) {
            return;
        }

        $bridge = new BridgeContent();

        $uuid = $bridge->contentInsert(
            type: 'task_cards',
            data: [
                'langcode' => 'fr',
                'type' => 'node',
                'bundle' => 'task_cards',
                "title" => 'Tâches',
                "introduction" => 'Les tâches recommandées par votre RR',
            ],
            creation: true,
            fromCli: true
        );

        $taskFr = type_to_class('task_cards')::find($uuid);

        $bridge->contentInsert(
            type: 'task_cards',
            data: [
                'langcode' => 'en',
                'type' => 'node',
                'bundle' => 'task_cards',
                "title" => 'Tasks',
                "introduction" => 'The tasks recommended by your HR',
                'uuid_host' => $taskFr->uuid_host,
            ],
            creation: true,
            fromCli: true
        );
    }
}
