<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

class CreateSalesforcePage extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $customPage = Custom::where(['redirection_page' => 'SalesforcePage', 'langcode' => 'fr'])->first();
        if ($customPage) {
            return;
        }

        $uuid = $bridge->contentInsert('custom', [
            'type' => 'node',
            'bundle' => 'custom',
            'langcode' => 'fr',
            'title' => 'Mes tâches ouvertes',
            'custom_slug' => 'salesforce',
            'redirection_page' => 'SalesforcePage',
        ]);

        $createdCustomPage = Custom::find($uuid);
        $bridge->contentInsert('custom', [
            'type' => 'node',
            'bundle' => 'custom',
            'langcode' => 'en',
            'title' => 'My Open Tasks',
            'uuid_host' => $createdCustomPage->uuid_host,
            'custom_slug' => 'salesforce',
            'redirection_page' => 'SalesforcePage',
        ]);
    }
}
