<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateProvidersType extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $fields = [
            'email',
            'phone',
            'providers_categories',
            'website',
            'name',
            'company_code',
            'last_update',
            'company_description',
            'brands',
            'management_modes',
            'countries',
            'profiles',
            'organization_unit'
        ];

        collect($fields)->each(function ($field) use ($bridgeContentType) {
            $bridgeContentType->updateFieldOptions('providers', $field, [
                'searchable' => true,
                'searchable_filter' => true,
                'search_result_field' => true,
            ]);
        });
    }
}
