<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Custom;

class CreateCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $uuid = $bridge->contentInsert('custom', [
            'type' => 'node',
            'bundle' => 'custom',
            'langcode' => 'fr',
            'title' => 'Annuaire des prestataires',
            'custom_slug' => 'providers-directory',
            'redirection_page' => 'ProvidersDirectoryPage',
        ]);

        $createdCustomPage = Custom::find($uuid);

        $bridge->contentInsert('custom', [
            'type' => 'node',
            'bundle' => 'custom',
            'langcode' => 'en',
            'title' => 'Service Providers Directory',
            'uuid_host' => $createdCustomPage->uuid_host,
            'custom_slug' => 'providers-directory',
            'redirection_page' => 'ProvidersDirectoryPage',
        ]);
    }


    public function down(): void
    {
    }
}
