<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddNewStatusNotifications extends Migration
{
    public function up(): void
    {
        // Supported statusUpdated Web
        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'system',
                'condition' => 'status:3',
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'text' => 'notifications.form.submission.supported.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        // Supported statusUpdatedAdmin Web
        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdatedAdmin',
                'type' => 'system',
                'condition' => 'status:3',
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'text' => 'notifications.form.admin.submission.supported.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        // Supported statusUpdated Mail
        NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'system',
                'condition' => 'status:3',
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'mail' => [
                        'subject' => 'notifications.form.submission.supported.email.subject',
                        'text' => 'notifications.form.submission.supported.email.text',
                        'buttonText' => 'notifications.form.submission.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        // Supported statusUpdatedAdmin Mail
        NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdatedAdmin',
                'type' => 'system',
                'condition' => 'status:3',
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'mail' => [
                        'subject' => 'notifications.form.submission.supported.email.subject',
                        'text' => 'notifications.form.submission.supported.email.text',
                        'buttonText' => 'notifications.form.submission.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );
    }
}
