<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Brands;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class UpdateBlocksAndAddFields extends Migration
{
    /**
     * @throws Exception
     */
    public function up(): void
    {
        $bridgeType = new BridgeContentType();
        $bridge = new BridgeContent();

        $bridgeType->contentTypeCreateOrUpdateField('p_and_p', 'weight', [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number is displayed first',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ]);
        $bridgeType->contentTypeCreateOrUpdateField('p_and_p_categories', 'weight', [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number is displayed first',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ]);

        $bridgeType->contentTypeUpdateOrCreate('blocks', [
            'name' => 'blocks',
            'translatable' => true,
            'searchable' => false,
            'global_searchable' => false,
            'aliasable' => false,
            'permissible' => true,
            'categorizable' => false,
            'listing_type' => 'content',
            'title' => [
                'fr' => 'Bloc',
                'en' => 'Block',
            ],
        ]);

        $bridgeType->contentTypeCreateOrUpdateField('brands', 'image', [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
            ],
            'description' => [
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ]);

        $brands = Brands::all();
        foreach ($brands as $brand) {
            $bridge->contentUpdate('brands', [
                'uuid' => $brand->uuid,
                'langcode' => $brand->langcode,
                'title' => $brand->title,
                'image' => $brand->icon
            ]);
        }

        $bridgeType->contentTypeDeleteField('node', 'brands', 'icon');
        $bridgeType->contentTypeDeleteField('node', 'blocks', 'icon_name');

        $bridgeType->contentTypeCreateOrUpdateField('blocks', 'icon', [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Icon',
                'en' => 'Icon',
            ],
            'description' => [
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $bridgeType->contentTypeCreateOrUpdateField('p_and_p_categories', 'icon', [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Icon',
                'en' => 'Icon',
            ],
            'description' => [
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
