<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDeskAlertStatisticsTable extends Migration
{
    public function up(): void
    {
        Schema::create(
            'desk_alerts_statistics',
            function (Blueprint $table) {
                $table->increments('id');
                $table->string('statistic_type');
                $table->dateTime('created_at');
                $table->dateTime('updated_at');

                $table->uuid('alert_uuid'); // foreign key ?
                $table->uuid('user_uuid'); // foreign key ?

                $table->index(['alert_uuid', 'user_uuid']);
            }
        );
    }

    public function down(): void
    {
        Schema::dropIfExists('desk_alerts_statistics');
    }
}
