<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\Comments;
use Inside\Host\Bridge\BridgeContent;

class FixCommentAuthors extends Migration
{
    /**
     *
     */
    public function up(): void
    {
        $bridge = new BridgeContent();
        $comments = Comments::query()->where('langcode', 'fr')->get();

        foreach ($comments as $comment) {
            $comment = Comments::query()->where('uuid_host', $comment->uuid_source)->first();
            $translationLangcode = $comment->langcode === 'fr' ? 'en' : 'fr';
            $commentTranslation = Comments::query()->where('uuid_source', $comment->uuid_source)->where('langcode', $translationLangcode)->first();
            if ($comment->uuid_host === $comment->uuid_source) {
                $original = $comment;
                $translation = $commentTranslation;
            } else {
                $original = $commentTranslation;
                $translation = $comment;
            }

            if ($original->author !== $translation->author && $original->author === '1d4f5c59-46c8-44c1-b939-d63a2e206cf8') {
                DB::table('inside_content_comments')->where('uuid', $original->uuid)->update([
                    'author' => $translation->author,
                    'author_id' => $translation->author_id
                ]);
            }
        }
    }

    public function down(): void
    {
    }
}
