<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Notify\Models\NotificationType;

class AddInsideEvents extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();
        $bridge->contentTypeUpdate('lhg_events', [
            'title' => [
                'fr' => 'Événement vidéo',
                'en' => 'Video event',
            ],
        ]);

        $this->migrateContent('events_categories', false);
        $this->migrateContent('events', false);

        $this->finishUp();

        $notificationTypes = NotificationType::query()->where('action', 'contentCommented')->where('condition', 'like', '%parent_type%')->get();

        /** @var NotificationType $notificationType */
        foreach ($notificationTypes as $notificationType) {
            $notificationType->condition = str_replace('parent_type:news', 'parent_type:news,events', $notificationType->condition ?? '');
            $notificationType->save();
        }
    }

    public function down(): void
    {
        $bridge = new \Inside\Host\Bridge\BridgeContentType();
        $bridge->contentTypeDelete('events_categories');
        $bridge->contentTypeDelete('events');
    }
}
