<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class AddBooleanFieldToNewsCategoriesType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->bridge->contentTypeCreateOrUpdateField('news_categories', 'is_identifiable_category', [
            'name' => 'is_identifiable_category',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 100,
            'title' => [
                'fr' => 'Est-ce que la catégorie est identifiable ?',
                'en' => 'Is identifiable category ?',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 100,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ]);

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
