<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateNewsType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->bridge->contentTypeCreateOrUpdateField('news_types', 'news_types_icon', [
            'name' => 'news_types_icon',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Icône',
                'en' => 'Icon',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
