<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class FixLastUpdateFieldOnForms extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            'last_update' => [
                'name' => 'last_update',
                'searchable' => false,
                'translatable' => true,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Dernière mise à jour',
                    'en' => 'Last update',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        ];

        foreach ($fields as $field) {
            $bridge->contentTypeCreateOrUpdateField('forms', $field['name'], $field);
        }

        Artisan::call('models:rebuild');
        Artisan::call('cache:clear');
    }


    public function down(): void
    {
    }
}
