<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddInternetExplorerLogoOnTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('tools', 'internet_explorer_logo', [
            'name' => 'internet_explorer_logo',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 200,
            'title' => [
                'fr' => 'Logo Internet Explorer',
                'en' => 'Internet Explorer logo',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 200,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
            'special' => [
                'image_styles' => [
                    'thumbnail',
                    'small',
                    'medium',
                    'big',
                ],
            ],
        ]);

        \Illuminate\Support\Facades\Artisan::call('models:rebuild');
        \Illuminate\Support\Facades\Artisan::call('cache:clear');
    }


    public function down(): void
    {
    }
}
