<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddInternetExplorerFieldOnTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('tools', 'internet_explorer_display', [
            'name' => 'internet_explorer_display',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 100,
            'title' => [
                'fr' => 'Afficher sur Internet Explorer',
                'en' => 'Display on Internet Explorer',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 100,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ]);

        \Illuminate\Support\Facades\Artisan::call('models:rebuild');
        \Illuminate\Support\Facades\Artisan::call('cache:clear');
    }


    public function down(): void
    {
    }
}
