<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldsOnForms extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            [
                'name' => 'brands',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'required' => true,
                'weight' => 6,
                'title' => [
                    'fr' => 'Marques',
                    'en' => 'Brands',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['brands'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            [
                'name' => 'countries',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 7,
                'title' => [
                    'fr' => 'Pays',
                    'en' => 'Countries',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['countries'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            [
                'name' => 'management_modes',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'required' => true,
                'weight' => 8,
                'title' => [
                    'fr' => 'Modes de gestion',
                    'en' => 'Management modes',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 8,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['management_modes'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            [
                'name' => 'profiles',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 9,
                'title' => [
                    'fr' => 'Profils',
                    'en' => 'Profiles',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 9,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['profiles'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            [
                'name' => 'news_categories',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Categories d\'actualités',
                    'en' => 'News categories',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 10,
                    'group' => 'group_publication_workflow',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['news_categories'],
                    'cardinality' => -1,
                ],
            ],
            [
                'name' => 'news_types',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 9,
                'title' => [
                    'fr' => 'Type d\'actualités',
                    'en' => 'News type',
                ],
                'widget' => [
                    'hidden' => true
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['news_types'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'regional_office_types',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Regional office type',
                    'en' => 'Regional office type',
                ],
                'widget' => [
                    'hidden' => true
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['regional_office_types'],
                    'cardinality' => 1,
                ],
            ],
            'last_update' => [
                'name' => 'last_update',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Dernière mise à jour',
                    'en' => 'Last update',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            'updated_by' => [
                'type' => BridgeContentType::REFERENCE_FIELD,
                'name' => 'updated_by',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 0,
                'default' => [],
                'title' => [
                    'fr' => 'Mis à jour par',
                    'en' => 'Updated by',
                ],
                'description' => [],
                'settings' => [
                    'cardinality' => -1,
                    'target_type' => 'users',
                ],
                'widget' => [
                    'hidden' => true,
                ],
            ],
        ];

        foreach ($fields as $field) {
            $bridge->contentTypeCreateOrUpdateField('forms', $field['name'], $field);
        }
    }


    public function down(): void
    {
    }
}
