<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddColorFieldsOnRegionalOfficeTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $fields = [
            [
                'name' => 'text_color',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'Couleur du texte',
                    'en' => 'Text color',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 8,
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'background_color',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'Couleur de fond',
                    'en' => 'Background color',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 8,
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        ];

        foreach ($fields as $field) {
            $this->bridge->contentTypeCreateOrUpdateField('regional_office_types', $field['name'], $field);
        }

        $this->finishUp();
    }


    public function down(): void
    {
    }
}
