<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\PAndPRegions;
use Inside\Notify\Models\NotificationType;

class AddPAndPNotificationType extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        NotificationType::query()->where('action', 'p_and_p_region_assignee_changed')->delete();

        \Inside\Notify\Models\NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('p_and_p'),
                'action'    => 'p_and_p_updated_manager',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.p_and_p.updated.title',
                    'description' => 'notifications.p_and_p.updated.description',
                    'icon'        => 'p_and_p',
                    'text'        => 'notifications.p_and_p.updated.text',
                    'fields' => ['title']
                ]
            ]
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
