<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\PAndPRegions;
use Inside\Notify\Models\NotificationType;

class ChangePAndPNotificationTypes extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $types = [
            'p_and_p_region_created',
            'p_and_p_region_assigned',
            'p_and_p_region_assignee_changed',
            'p_and_p_updated'
        ];

        foreach ($types as $type) {
            NotificationType::query()->where('action', $type)->delete();
        }

        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('p_and_p_regions'),
                'action'    => 'p_and_p_region_created',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.p_and_p.region.title',
                    'description' => 'notifications.p_and_p.region.description',
                    'icon'        => 'p_and_p',
                    'text'        => 'notifications.p_and_p.region.text',
                    'fields' => ['title']
                ]
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('p_and_p_regions'),
                'action'    => 'p_and_p_region_assigned',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.p_and_p.region_assigned.title',
                    'description' => 'notifications.p_and_p.region_assigned.description',
                    'icon'        => 'p_and_p',
                    'text'        => 'notifications.p_and_p.region_assigned.text',
                    'fields' => ['title']
                ]
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('p_and_p_regions'),
                'action'    => 'p_and_p_region_assignee_changed',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.p_and_p.region_assignee_changed.title',
                    'description' => 'notifications.p_and_p.region_assignee_changed.description',
                    'icon'        => 'p_and_p',
                    'text'        => 'notifications.p_and_p.region_assignee_changed.text',
                    'fields' => ['title']
                ]
            ]
        );

        \Inside\Notify\Models\NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('p_and_p'),
                'action'    => 'p_and_p_updated',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.p_and_p.updated.title',
                    'description' => 'notifications.p_and_p.updated.description',
                    'icon'        => 'p_and_p',
                    'text'        => 'notifications.p_and_p.updated.text',
                    'fields' => ['title']
                ]
            ]
        );

        \Inside\Notify\Models\NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('p_and_p'),
                'action'    => 'p_and_p_published',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.p_and_p.published.title',
                    'description' => 'notifications.p_and_p.published.description',
                    'icon'        => 'p_and_p',
                    'text'        => 'notifications.p_and_p.published.text',
                    'fields' => ['title']
                ]
            ]
        );

        \Inside\Notify\Models\NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('p_and_p'),
                'action'    => 'p_and_p_email',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
                'data'      => null
            ]
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
