<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditContactsEmailsAndPhonesFields extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->bridge->contentTypeDeleteField('node', 'contacts', 'emails');
        $this->bridge->contentTypeDeleteField('node', 'contacts', 'phones');

        $fields = [
            [
                'name' => 'first_email',
                'fr' => 'Premier Email',
                'en' => 'First Email'
            ],
            [
                'name' => 'second_email',
                'fr' => 'Second Email',
                'en' => 'Second Email'
            ],
            [
                'name' => 'first_phone',
                'fr' => 'Premier Téléphone',
                'en' => 'First Phone'
            ],
            [
                'name' => 'second_phone',
                'fr' => 'Second Téléphone',
                'en' => 'Second Phone'
            ]
        ];
        $weight = -4; // arbitrary value but it puts these fields as first ones in the drupal form

        foreach ($fields as $field) {
            $this->bridge->contentTypeCreateOrUpdateField(
                'contacts',
                $field['name'],
                [
                    'name' => $field['name'],
                    'searchable' => true,
                    'translatable' => false,
                    'search_result_field' => false,
                    'required' => false,
                    'title' => [
                        'fr' => $field['fr'],
                        'en' => $field['en'],
                    ],
                    'widget' => [
                        'type' => BridgeContentType::STRING_WIDGET,
                        'settings' => [
                            'size' => 60,
                            'placeholder' => '',
                        ],
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'cardinality' => 1,
                    ],
                ],
                $weight++
            );
        }
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
