<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddToolsFieldToUsers extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $userFields = [
            [
                'name' => 'tools',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Outils',
                    'en' => 'Tools',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['tools'],
                    'cardinality' => -1,
                ],
                'selectable_all' => false,
            ],
        ];

        $this->bridge->contentTypeDeleteField('user', 'user', 'shortcuts_menus');

        foreach ($userFields as $userField) {
            $this->bridge->contentTypeCreateOrUpdateField('users', $userField['name'], $userField);
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
