<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UserFieldsMigration extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('regional_offices', false);
        $this->migrateContent('business_units', false);

        $userFields = [
            [
                'name' => 'api_id',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'API ID',
                    'en' => 'API ID',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'brands',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Marques',
                    'en' => 'Brands',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['brands'],
                    'cardinality' => -1,
                ],
                'selectable_all' => false,
            ],
            [
                'name' => 'business_units',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Business Units',
                    'en' => 'Business Units',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['business_units'],
                    'cardinality' => -1,
                ],
                'selectable_all' => false,
            ],
            [
                'name' => 'countries',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Pays',
                    'en' => 'Countries',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['countries'],
                    'cardinality' => -1,
                ],
                'selectable_all' => false,
            ],
            [
                'name' => 'management_modes',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Modes de gestion',
                    'en' => 'Management modes',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['management_modes'],
                    'cardinality' => -1,
                ],
                'selectable_all' => false,
            ],
            [
                'name' => 'profiles',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Profils',
                    'en' => 'Profiles',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['profiles'],
                    'cardinality' => -1,
                ],
                'selectable_all' => false,
            ],
            [
                'name' => 'regional_offices',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Bureaux régionaux',
                    'en' => 'Regional offices',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['regional_offices'],
                    'cardinality' => -1,
                ],
                'selectable_all' => false,
            ],
        ];

        foreach ($userFields as $userField) {
            $this->bridge->contentTypeCreateOrUpdateField('users', $userField['name'], $userField);
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
