<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 0;
return [
    'options' => [
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'news',
        'title' => [
            'fr' => 'Actualités',
            'en' => 'News',
        ],
    ],
    'groups' => [
        [
            'group_name'      => 'group_visibility_rights',
            'entity_type'     => 'node',
            'bundle'          => 'news',
            'children'        => [
                'brands',
                'countries',
                'management_modes',
                'profiles',
            ],
            'weight'          => 4,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Rights of visibility',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Rights of visibility',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_advanced_options',
            'entity_type'     => 'node',
            'bundle'          => 'news',
            'children'        => [
                'langcode',
                'created',
                'uid',
            ],
            'weight'          => 5,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Advanced options',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Advanced options',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_publication_workflow',
            'entity_type'     => 'node',
            'bundle'          => 'news',
            'children'        => [
                'news_types',
                'news_categories',
                'is_featured',
                'status'
            ],
            'weight'          => 6,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Publication Workflow',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Publication Workflow',
            'format_type'     => 'fieldset',
        ],

    ],
    'fields' => [
        [
            'name' => 'chapo',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Chapô',
                'en' => 'Headline',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content'
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => ['text', 'text_with_image', 'image', 'file', 'video', 'map', 'html', 'accordion', 'call_to_action', 'files', 'slider'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'users',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Contacts',
                'en' => 'Contacts',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'cardinality' => -1,
                'target_type' => 'users',
            ],
        ],
        [
            'name' => 'brands',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Marques',
                'en' => 'Brands',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'countries',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Pays',
                'en' => 'Countries',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['countries'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'management_modes',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 7,
            'title' => [
                'fr' => 'Modes de gestion',
                'en' => 'Management modes',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 7,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['management_modes'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'profiles',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 8,
            'title' => [
                'fr' => 'Profils',
                'en' => 'Profiles',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 8,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['profiles'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'is_featured',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'default' => false,
            'weight' => 11,
            'title' => [
                'fr' => 'À la une',
                'en' => 'Featured',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 11,
                'group' => 'group_publication_workflow',
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'news_types',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 9,
            'title' => [
                'fr' => 'Type d\'actualités',
                'en' => 'News type',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 9,
                'group' => 'group_publication_workflow',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_types'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'news_categories',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Categories d\'actualités',
                'en' => 'News categories',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 10,
                'group' => 'group_publication_workflow',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
        ],
    ],
];
