<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'memorandums',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'title' => [
            'fr' => 'Mémorandums',
            'en' => 'Memorandums',
        ],
    ],
    'groups' => [
        [
            'group_name'      => 'group_infos',
            'entity_type'     => 'node',
            'bundle'          => 'memorandums',
            'children'        => [
                'from',
                'to',
                'cc',
            ],
            'weight'          => 4,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Informations',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Informations',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_contact',
            'entity_type'     => 'node',
            'bundle'          => 'memorandums',
            'children'        => [
                'contact',
                'function',
            ],
            'weight'          => 4,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Contact',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Contact',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_visibility_rights',
            'entity_type'     => 'node',
            'bundle'          => 'memorandums',
            'children'        => [
                'brands',
                'countries',
                'management_modes',
                'profiles',
            ],
            'weight'          => 4,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Rights of visibility',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Rights of visibility',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_advanced_options',
            'entity_type'     => 'node',
            'bundle'          => 'memorandums',
            'children'        => [
                'langcode',
                'created',
                'uid',
            ],
            'weight'          => 5,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Advanced options',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Advanced options',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_publication_workflow',
            'entity_type'     => 'node',
            'bundle'          => 'memorandums',
            'children'        => [
                'news_categories',
                'status'
            ],
            'weight'          => 6,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Publication Workflow',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Publication Workflow',
            'format_type'     => 'fieldset',
        ],

    ],
    'fields' => [
        [
            'name' => 'brand',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Marque',
                'en' => 'Brand',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'from',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'De',
                'en' => 'From',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
                'group' => 'group_infos',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'to',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'À',
                'en' => 'To',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
                'group' => 'group_infos',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'cc',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'CC',
                'en' => 'CC',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
                'group' => 'group_infos',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'accordion',
                    'call_to_action',
                    'file',
                    'files',
                    'html',
                    'image',
                    'map',
                    'slide',
                    'slider',
                    'text',
                    'text_with_image',
                    'tweet',
                    'video',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'brands',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Marques',
                'en' => 'Brands',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'countries',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Pays',
                'en' => 'Countries',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['countries'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'management_modes',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 7,
            'title' => [
                'fr' => 'Modes de gestion',
                'en' => 'Management modes',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 7,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['management_modes'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'profiles',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 8,
            'title' => [
                'fr' => 'Profils',
                'en' => 'Profiles',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 8,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['profiles'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'news_categories',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => 9,
            'title' => [
                'fr' => 'Catégories d\'actualités',
                'en' => 'News categories',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 9,
                'group' => 'group_publication_workflow',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'contact',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 10,
            'title' => [
                'fr' => 'Utilisateur',
                'en' => 'User',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 10,
                'group' => 'group_contact',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'function',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 11,
            'title' => [
                'fr' => 'Fonction',
                'en' => 'Function',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 11,
                'group' => 'group_contact',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
