<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'lhg_events',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'title' => [
            'fr' => 'Événement',
            'en' => 'Event',
        ],
        'listing_type' => 'content',
    ],
    'groups' => [
        [
            'group_name'      => 'group_visibility_rights',
            'entity_type'     => 'node',
            'bundle'          => 'news',
            'children'        => [
                'brands',
                'countries',
                'management_modes',
                'profiles',
            ],
            'weight'          => 4,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Rights of visibility',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Rights of visibility',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_advanced_options',
            'entity_type'     => 'node',
            'bundle'          => 'news',
            'children'        => [
                'langcode',
                'created',
                'uid',
            ],
            'weight'          => 5,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Advanced options',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Advanced options',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_publication_workflow',
            'entity_type'     => 'node',
            'bundle'          => 'news',
            'children'        => [
                'date',
                'status'
            ],
            'weight'          => 6,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Publication Workflow',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Publication Workflow',
            'format_type'     => 'fieldset',
        ],
    ],
    'fields' => [
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'video_link',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Lien vers la vidéo',
                'en' => 'Video link',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'date',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Date de début',
                'en' => 'Start date',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 2,
                'group' => 'group_publication_workflow',
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'brands',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Marques',
                'en' => 'Brands',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'countries',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Pays',
                'en' => 'Countries',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['countries'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'management_modes',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Modes de gestion',
                'en' => 'Management modes',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['management_modes'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'profiles',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Profils',
                'en' => 'Profiles',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['profiles'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'updated_by',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Mis à jour par',
                'en' => 'Updated by',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'last_update',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Dernière mise à jour',
                'en' => 'Last update',
            ],
            'widget' => [
                'hidden' => true
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
