<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'career_infos',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'title' => [
            'fr' => 'Infos Carrière',
            'en' => 'Career Infos',
        ],
    ],
    'groups' => [
        [
            'group_name'      => 'group_presentation',
            'entity_type'     => 'node',
            'bundle'          => 'career_infos',
            'children'        => [
                'hotel_name',
                'candidacies_end',
            ],
            'weight'          => 4,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Presentation',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Presentation',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_general',
            'entity_type'     => 'node',
            'bundle'          => 'career_infos',
            'children'        => [
                'hotel_description_text',
                'hotel_description_image',
                'hotel_environment_text',
                'hotel_environment_image',
                'missions',
                'profile'
            ],
            'weight'          => 4,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Presentation',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Presentation',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_visibility_rights',
            'entity_type'     => 'node',
            'bundle'          => 'career_infos',
            'children'        => [
                'brands',
                'countries',
                'management_modes',
                'profiles',
            ],
            'weight'          => 4,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Rights of visibility',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Rights of visibility',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_advanced_options',
            'entity_type'     => 'node',
            'bundle'          => 'career_infos',
            'children'        => [
                'langcode',
                'created',
                'uid',
            ],
            'weight'          => 5,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Advanced options',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Advanced options',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_publication_workflow',
            'entity_type'     => 'node',
            'bundle'          => 'career_infos',
            'children'        => [
                'news_categories',
                'status'
            ],
            'weight'          => 6,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'Publication Workflow',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'Publication Workflow',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_contact_info',
            'entity_type'     => 'node',
            'bundle'          => 'career_infos',
            'children'        => [
                'contact_info_user',
                'contact_info_function',
                'contact_info_phone',
            ],
            'weight'          => 6,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'To get informed',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'To get informed',
            'format_type'     => 'fieldset',
        ],
        [
            'group_name'      => 'group_contact_apply',
            'entity_type'     => 'node',
            'bundle'          => 'career_infos',
            'children'        => [
                'contact_apply_user',
                'contact_apply_function',
                'contact_apply_phone',
            ],
            'weight'          => 6,
            'parent_name'     => '',
            'format_settings' => [
                'label'           => 'To apply',
                'description'     => '',
                'required_fields' => true,
                'id'              => '',
                'classes'         => '',
            ],
            'label'           => 'To apply',
            'format_type'     => 'fieldset',
        ],
    ],
    'fields' => [
        [
            'name' => 'brand',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Marque',
                'en' => 'Brand',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Visuel',
                'en' => 'Visual',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'hotel_name',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Nom de l\'hôtel',
                'en' => 'Hotel name',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
                'group' => 'group_presentation',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'candidacies_end',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Fin des candidatures',
                'en' => 'Candidacies end',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
                'group' => 'group_presentation',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'hotel_description_text',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Descriptif de l\'hôtel',
                'en' => 'Hotel description',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 4,
                'group' => 'group_general',
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'hotel_description_image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Visuel',
                'en' => 'Visual',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 5,
                'group' => 'group_general',
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'hotel_environment_text',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Environnement de l\'hôtel',
                'en' => 'Hotel environment',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 6,
                'group' => 'group_general',
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'hotel_environment_image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 7,
            'title' => [
                'fr' => 'Visuel',
                'en' => 'Visual',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 7,
                'group' => 'group_general',
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'missions',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 8,
            'title' => [
                'fr' => 'Missions principales',
                'en' => 'Principal missions',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 8,
                'group' => 'group_general',
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'accordion',
                    'call_to_action',
                    'file',
                    'files',
                    'html',
                    'image',
                    'map',
                    'slide',
                    'slider',
                    'text',
                    'text_with_image',
                    'tweet',
                    'video',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'profile',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 9,
            'title' => [
                'fr' => 'Profil',
                'en' => 'Profile',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 9,
                'group' => 'group_general',
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'accordion',
                    'call_to_action',
                    'file',
                    'files',
                    'html',
                    'image',
                    'map',
                    'slide',
                    'slider',
                    'text',
                    'text_with_image',
                    'tweet',
                    'video',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'brands',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 10,
            'title' => [
                'fr' => 'Marques',
                'en' => 'Brands',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 10,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'countries',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 11,
            'title' => [
                'fr' => 'Pays',
                'en' => 'Countries',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 11,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['countries'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'management_modes',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 12,
            'title' => [
                'fr' => 'Modes de gestion',
                'en' => 'Management modes',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 12,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['management_modes'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'profiles',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 13,
            'title' => [
                'fr' => 'Profils',
                'en' => 'Profiles',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 13,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['profiles'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'contact_info_user',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 14,
            'title' => [
                'fr' => 'Utilisateur',
                'en' => 'User',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 14,
                'group' => 'group_contact_info',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'contact_info_function',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 15,
            'title' => [
                'fr' => 'Fonction',
                'en' => 'Function',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 15,
                'group' => 'group_contact_info',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'contact_info_phone',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 16,
            'title' => [
                'fr' => 'Téléphone',
                'en' => 'Phone',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 16,
                'group' => 'group_contact_info',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'contact_apply_user',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 17,
            'title' => [
                'fr' => 'Utilisateur',
                'en' => 'User',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 17,
                'group' => 'group_contact_apply'
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'contact_apply_function',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 18,
            'title' => [
                'fr' => 'Fonction',
                'en' => 'Function',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 18,
                'group' => 'group_contact_apply'
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'contact_apply_phone',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 19,
            'title' => [
                'fr' => 'Téléphone',
                'en' => 'Phone',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 19,
                'group' => 'group_contact_apply'
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'news_categories',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => 20,
            'title' => [
                'fr' => 'Catégories d\'actualités',
                'en' => 'News categories',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 20,
                'group' => 'group_publication_workflow',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
        ],
    ],
];
