<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'alerts',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'title' => [
            'fr' => 'Alertes',
            'en' => 'Alerts',
        ],
    ],
    'fields' => [
        [
            'name' => 'chapo',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Bandeau d\'alerte',
                'en' => 'Alert banner',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'body',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Pop-in',
                'en' => 'Pop-in',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Pièce-jointe',
                'en' => 'Attachment',
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'brands',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Marques',
                'en' => 'Brands',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'countries',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Pays',
                'en' => 'Countries',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['countries'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'management_modes',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Modes de gestion',
                'en' => 'Management modes',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['management_modes'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'profiles',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Profils',
                'en' => 'Profiles',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['profiles'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'last_update',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Dernière mise à jour',
                'en' => 'Last update',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 7,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'updated_by',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Mis à jour par',
                'en' => 'Updated by',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 8,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
            'selectable_all' => false,
        ],
        [
            'name' => 'email_object',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 9,
            'title' => [
                'fr' => 'Objet de l\'email',
                'en' => 'Email object',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 9,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'email_content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 10,
            'title' => [
                'fr' => 'Contenu de l\'email',
                'en' => 'Email content',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
