<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace' => 'Inside\DESK\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('popin', ['uses' => 'PopinController@popin']);
        $router->post('reaction/popin', ['uses' => 'PopinController@reaction']);

        $router->get('desk/newsletter', ['uses' => 'NewsletterController@send']);

        $router->put('desk/tools/{uuid}', ['uses' => 'ToolsController@update']);

        // SalesForce
        $router->get('salesforce/tasks', ['uses' => 'SalesForceApiController@getTasks']);
        $router->get('salesforce/tasks/categories', ['uses' => 'SalesForceApiController@getCategories']);
        $router->get('salesforce/tasks/{taskId}', ['uses' => 'SalesForceApiController@getTask']);
        $router->patch('salesforce/tasks/{taskId}', ['uses' => 'SalesForceApiController@updateTask']);
        $router->post('salesforce/complete-task', ['uses' => 'SalesForceApiController@completeTask']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\DESK\Http\Controllers',
        'prefix' => '',
    ],
    function ($router) {
        $router->get('internet-explorer', ['uses' => 'IEController@index']);

        $router->get('desk/alerts/{alertUuid}/{userUuid}/viewed.png', ['uses' => 'AlertsDeskStatisticsController@viewed', 'as' => 'desk.alerts.viewed']);
        $router->get('desk/alerts/{alertUuid}/{userUuid}/clicked', ['uses' => 'AlertsDeskStatisticsController@clicked', 'as' => 'desk.alerts.clicked']);

        $router->get('desk/newsletters/{newsletterDate}/{userUuid}/viewed.png', ['uses' => 'NewslettersDeskStatisticsController@viewed', 'as' => 'desk.newsletters.viewed']);
        $router->get('desk/newsletters/{newsletterDate}/{userUuid}/clicked', ['uses' => 'NewslettersDeskStatisticsController@clicked', 'as' => 'desk.newsletters.clicked']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\DESK\Http\Controllers',
        'prefix' => '',
        'middleware' => ['auth.talend'],
    ],
    function ($router) {
        $router->get('desk/talend/export/{filename}', ['uses' => 'TalendExportController@export']);
    }
);

Route::group(
    [
        'prefix' => 'api/v1',
        'namespace' => 'Inside\DESK\Http\Controllers',
        'middleware' => ['auth.backoffice.access:desk_email_statistic'],
    ],
    function ($router) {
        $router->get('desk/stats/alerts', ['uses' => 'AlertsDeskStatisticsController@index']);
        $router->get('desk/stats/alerts/export', ['uses' => 'AlertsDeskStatisticsController@export']);
        $router->get('desk/stats/alerts/{alertUuid}/views', ['uses' => 'AlertsDeskStatisticsController@views']);
        $router->get('desk/stats/alerts/{alertUuid}/views/export', ['uses' => 'AlertsDeskStatisticsController@viewsExport']);

        $router->get('desk/stats/newsletters', ['uses' => 'NewslettersDeskStatisticsController@index']);
        $router->get('desk/stats/newsletters/export', ['uses' => 'NewslettersDeskStatisticsController@export']);
        $router->get('desk/stats/newsletters/{newsletterDate}/views', ['uses' => 'NewslettersDeskStatisticsController@views']);
        $router->get('desk/stats/newsletters/{newsletterDate}/views/export', ['uses' => 'NewslettersDeskStatisticsController@viewsExport']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\DESK\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.external:external_api'],
    ],
    function ($router) {
        $router->get('external/resource/{path:.*}', ['uses' => 'ExternalApiController@getResource']);
    }
);
