<?php

namespace Inside\DESK\Providers;

use Inside\Authentication\Events\AuthenticationLoginEvent;
use Inside\Content\Events\CommentCreatedEvent;
use Inside\Content\Events\CommentDeletedEvent;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\DESK\Console\ComputeNewslettersStatisticsCommand;
use Inside\DESK\Console\ExportUsersInformations;
use Inside\DESK\Console\FixMissingCommentsCommand;
use Inside\DESK\Console\FixMissingFormAnswersCommand;
use Inside\DESK\Console\SendAlerts;
use Inside\DESK\Console\SendNewsletters;
use Inside\DESK\Contracts\DeskStatistics;
use Inside\DESK\Contracts\UrlSigner;
use Inside\DESK\Http\Middlewares\NotificationsMiddleware;
use Inside\DESK\Http\Middlewares\TalendExportMiddleware;
use Inside\DESK\Http\Middlewares\ToolsMiddleware;
use Inside\DESK\Listeners\AuthenticationLoginListener;
use Inside\DESK\Listeners\CommentInsertedListener;
use Inside\DESK\Listeners\CommentDeletedListener;
use Inside\DESK\Listeners\ContentInsertedListener;
use Inside\DESK\Listeners\FormStatusListener;
use Inside\DESK\Listeners\FormSubmittedListener;
use Inside\DESK\Listeners\ReactionSubscribedListener;
use Inside\DESK\Listeners\ReactionUnsubscribedListener;
use Inside\DESK\Listeners\FormSubmissionDeletedListener;
use Inside\DESK\Services\DeskStatisticsService;
use Inside\DESK\Services\UrlSignerService;
use Inside\Form\Events\FormSubmissionStatusEditedEvent;
use Inside\Form\Events\FormSubmitedEvent;
use Inside\Form\Events\FormSubmissionDeletedEvent;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;
use Inside\DESK\Services\SalesForceService;
use Inside\DESK\Facades\SalesForce;

/**
 * DESK Service provider.
 *
 * @category Class
 * @package  Inside\DESK\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        AuthenticationLoginEvent::class => [
            AuthenticationLoginListener::class,
        ],
        CommentCreatedEvent::class => [
            CommentInsertedListener::class,
        ],
        CommentDeletedEvent::class => [
            CommentDeletedListener::class,
        ],
        ContentInsertedEvent::class => [
            ContentInsertedListener::class,
        ],
        FormSubmitedEvent::class => [
            FormSubmittedListener::class,
        ],
        FormSubmissionDeletedEvent::class => [
            FormSubmissionDeletedListener::class
        ],
        FormSubmissionStatusEditedEvent::class => [
            FormStatusListener::class,
        ],
        ReactionSubscribedEvent::class => [
            ReactionSubscribedListener::class,
        ],
        ReactionUnsubscribedEvent::class => [
            ReactionUnsubscribedListener::class,
        ],
    ];

    public array $bindings = [
        DeskStatistics::class => DeskStatisticsService::class,
        UrlSigner::class => UrlSignerService::class,
        SalesForce::class => SalesForceService::class
    ];

    protected array $commands = [
        SendNewsletters::class,
        SendAlerts::class,
        ExportUsersInformations::class,
        ComputeNewslettersStatisticsCommand::class,
        FixMissingFormAnswersCommand::class,
        FixMissingCommentsCommand::class
    ];

    public function register(): void
    {
        try {
            $this->mergeConfigTo(__DIR__.'/../../config/archive.php', 'archive');
            $this->mergeConfigTo(__DIR__.'/../../config/report.php', 'report');
            $this->mergeConfigTo(__DIR__.'/../../config/louvrehotels.php', 'louvrehotels');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/workers.php', 'workers');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/workflow.php', 'workflow');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__.'/../../config/form.php', 'form');
            $this->mergeConfigTo(__DIR__.'/../../config/user-seen.php', 'user-seen');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/salesforce_api.php', 'salesforce_api');
            $this->mergeConfigTo(__DIR__.'/../../config/tableau.php', 'tableau');
            $this->mergeConfigTo(__DIR__.'/../../config/external_api.php', 'external_api');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/horizon.php', 'horizon');
            $this->mergeConfigTo(__DIR__.'/../../config/talend.php', 'talend');
            $this->mergeConfigTo(__DIR__.'/../../config/audit.php', 'audit');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }

        $this->app->middleware([
            NotificationsMiddleware::class,
            ToolsMiddleware::class,
        ]);

        $this->app->routeMiddleware([
            'auth.talend' => TalendExportMiddleware::class,
        ]);
    }
}
