<?php

declare(strict_types=1);

namespace Inside\DESK\Models;

use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property int $newsletter_uuid
 * @property string $user_uuid
 * @property string $statistic_type
 * @property int $created_at
 * @property int $updated_at
 * @method static static firstOrCreate($data)
 * @method static static create($data)
 * @method static Builder query()
 * @method static Builder join($table, $first, $operator = null, $second = null, $type = 'inner', $where = false)
 * @method static Builder rightJoin($table, $first, $operator = null, $second = null, $type = 'inner', $where = false)
 */
class NewsletterStatistic extends Model
{
    use WithEnhancedBuilder;

    public const TYPE_SENT = 'sent';
    public const TYPE_CLICKED = 'clicked';
    public const TYPE_VIEWED = 'viewed';

    protected $table = 'desk_newsletters_statistics';

    protected $casts = [
        'newsletter_date' => 'timestamp',
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];

    protected $fillable = [
        'newsletter_date',
        'user_uuid',
        'statistic_type',
    ];
}
