<?php

namespace Inside\DESK\Models;

use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property string $alert_uuid
 * @property string $user_uuid
 * @property string $statistic_type
 * @property int $created_at
 * @property int $updated_at
 * @method static AlertStatistic firstOrCreate($data)
 * @method static AlertStatistic create($data)
 * @method static Builder join($table, $first, $operator = null, $second = null, $type = 'inner', $where = false)
 */
class AlertStatistic extends Model
{
    use WithEnhancedBuilder;

    public const TYPE_SENT = 'sent';
    public const TYPE_CLICKED = 'clicked';
    public const TYPE_VIEWED = 'viewed';

    public const TYPES = [
        self::TYPE_SENT,
        self::TYPE_CLICKED,
        self::TYPE_VIEWED,
    ];

    protected $table = 'desk_alerts_statistics';

    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];

    protected $fillable = [
        'alert_uuid',
        'user_uuid',
        'statistic_type',
    ];
}
