<?php

namespace Inside\DESK\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Inside\Content\Models\Contents\Alerts;
use Inside\DESK\Facades\UrlSigner;

class Alert extends Mailable
{
    use Queueable;
    use SerializesModels;

    protected Alerts $alert;
    protected string $userUuid;

    /**
     * @var string
     */
    public $locale;

    public function __construct(Alerts $alert, string $userUuid, ?string $locale)
    {
        $this->locale = $locale ?? 'en';
        $this->alert = $alert;
        $this->userUuid = $userUuid;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $trackingPixelUrl = UrlSigner::signedRoute('desk.alerts.viewed', ['alertUuid' => $this->alert->uuid, 'userUuid' => $this->userUuid]);
        $trackingClickUrl = UrlSigner::signedRoute('desk.alerts.clicked', ['alertUuid' => $this->alert->uuid, 'userUuid' => $this->userUuid]);

        return $this->markdown('emails.alert')->subject(
            $this->alert->email_object
        )->with(
            [
                'content' => nl2br($this->alert->email_content),
                'locale' => $this->locale,
                'trackingPixelUrl' => $trackingPixelUrl,
                'trackingClickUrl' => $trackingClickUrl,
            ]
        );
    }
}
