<?php

namespace Inside\DESK\Http\Controllers;

use Illuminate\Http\Request;
use Laravel\Lumen\Routing\Controller;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class TalendExportController extends Controller
{
    public function export(Request $request): BinaryFileResponse
    {
        $filename = $request->route('filename');

        $path = storage_path('app/protected/exports/' . $filename);

        if (! file_exists($path)) {
            abort(404);
        }

        /** @phpstan-ignore-next-line */
        return response()->download($path);
    }
}
