<?php

namespace Inside\DESK\Audit;

use Inside\Settings\Audit\Tests\BaseTest;

class CommentsTranslationsExistenceTest extends BaseTest
{
    public static function check(): bool
    {
        $missingUuidSources = type_to_class('comments')::query()
            ->select('uuid_source')
            ->whereNotNull('uuid_source')
            ->whereIn('langcode', list_languages())
            ->groupBy('uuid_source')
            ->havingRaw('COUNT(DISTINCT langcode) < ?', [count(list_languages())])
            ->pluck('uuid_source');

        if ($missingUuidSources->isNotEmpty()) {
            self::setMessage(__('audit.comments.translations.missing') . $missingUuidSources->implode(','));

            return false;
        }

        self::setMessage(__('audit.comments.translations.success') . $missingUuidSources->implode(','));
        return true;
    }

    public static function getLabel(): string
    {
        return __('audit.comments.translations.existence.test.title');
    }
}
