@php ($assetPath    = '/themes/custom/inside-drupal-theme/assets')
@php ($documentRoot = filter_input(INPUT_SERVER, 'DOCUMENT_ROOT', FILTER_SANITIZE_STRING))
@php ($buildTime    = file_exists($documentRoot . $assetPath) ? filemtime($documentRoot . $assetPath) ?? 0 : 0)
@spaceless
<!DOCTYPE html>
<html lang="{{ $user->langcode }}">
<head>
    <meta charset=utf-8>
    <meta name=viewport content="width=device-width,user-scalable=yes,initial-scale=1.0,maximum-scale=5.0">
    <meta name=HandheldFriendly content=true>

    <meta name=application-name content="{{ env('APP_NAME') }}">
    <meta name=mobile-web-app-capable content=yes>
    <meta name=theme-color content="{{ env('WEBAPP_COLOR', '#fbb3a7') }}">

    <meta name=apple-mobile-web-app-capable content=yes />
    <meta name=apple-mobile-web-app-title content="{{ env('APP_NAME') }}">
    <meta name=apple-mobile-web-app-status-bar-style content=#ffffff>

    <meta http-equiv=X-UA-Compatible content="IE=edge">
    <meta name=format-detection" content="telephone=no">

    <meta name=msapplication-config content="{{ $assetPath }}/assets/browserconfig.xml" />
    <meta name=msapplication-TileColor content="{{ env('WEBAPP_COLOR', '#fbb3a7') }}">
    <meta name=msapplication-TileImage content="{{ $assetPath }}/assets/img/app-logo/mstile-144x144.png">

    <meta name=robots content=noindex>
    <meta name=description content="{{ env('APP_NAME') }}">
    <title>{{ env('APP_NAME') }}</title>
    <link rel="shortcut icon" href="{{ $assetPath }}/favicon.ico?t={{ $buildTime }}" type="image/x-icon" />

    <link rel="icon" type="image/png" sizes="192x192" href="{{ $assetPath }}/img/app-logo/android-chrome-192x192.png?t={{ $buildTime }}">

    <link rel="icon" type="image/png" sizes="16x16" href="{{ $assetPath }}/img/app-logo/android-chrome-16x16.png?t={{ $buildTime }}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{ $assetPath }}/img/app-logo/android-chrome-32x32.png?t={{ $buildTime }}">
    <link rel="icon" type="image/png" sizes="194x194" href="{{ $assetPath }}/img/app-logo/android-chrome-194x194.png?t={{ $buildTime }}">

    <link rel="apple-touch-icon" href="{{ $assetPath }}/img/app-logo/apple-touch-icon.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-precomposed.png?t={{ $buildTime }}">

    <link rel="apple-touch-icon" sizes="57x57" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-57x57.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="60x60" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-60x60.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="72x72" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-72x72.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="76x76" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-76x76.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="114x114" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-114x114.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="120x120" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-120x120.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="144x144" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-144x144.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="152x152" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-152x152.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-180x180.png?t={{ $buildTime }}">

    <link rel="apple-touch-icon-precomposed" sizes="57x57" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-57x57-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="60x60" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-60x60-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-72x72-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="76x76" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-76x76-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-114x114-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="120x120" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-120x120-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-144x144-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="152x152" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-152x152-precomposed.png?t={{ $buildTime }}">
    <link rel="apple-touch-icon-precomposed" sizes="180x180" href="{{ $assetPath }}/img/app-logo/apple-touch-icon-180x180-precomposed.png?t={{ $buildTime }}">

    <link rel="apple-touch-startup-image" sizes="320x460" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-320x460.png?t={{ $buildTime }}" media="(device-width: 320px) and (-webkit-device-pixel-ratio: 1)">
    <link rel="apple-touch-startup-image" sizes="768x1004" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-768x1004.png?t={{ $buildTime }}" media="(device-width: 768px) and (-webkit-device-pixel-ratio: 1) and (orientation: portrait)">
    <link rel="apple-touch-startup-image" sizes="748x1024" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-748x1024.png?t={{ $buildTime }}" media="(device-width: 768px) and (-webkit-device-pixel-ratio: 1) and (orientation: landscape)">
    <link rel="apple-touch-startup-image" sizes="640x920" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-640x920.png?t={{ $buildTime }}" media="(device-width: 320px) and (-webkit-device-pixel-ratio: 2)">
    <link rel="apple-touch-startup-image" sizes="750x1334" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-750x1334.png?t={{ $buildTime }}" media="(device-width: 375px) and (-webkit-device-pixel-ratio: 2)">
    <link rel="apple-touch-startup-image" sizes="1536x2008" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-1536x2008.png?t={{ $buildTime }}" media="(device-width: 768px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)">
    <link rel="apple-touch-startup-image" sizes="2048x1496" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-2048x1496.png?t={{ $buildTime }}" media="(device-width: 768px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)">
    <link rel="apple-touch-startup-image" sizes="1242x2208" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-1242x2208.png?t={{ $buildTime }}" media="(device-width: 414px) and (-webkit-device-pixel-ratio: 3)">
    <link rel="apple-touch-startup-image" sizes="1242x2148" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-1242x2208.png?t={{ $buildTime }}" media="(device-width: 414px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)">
    <link rel="apple-touch-startup-image" sizes="1182x2208" href="{{ $assetPath }}/img/app-logo/apple-touch-startup-image-1242x2208.png?t={{ $buildTime }}" media="(device-width: 414px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)">

    <link rel="mask-icon" href="{{ $assetPath }}/img/app-logo/safari-pinned-tab.svg?t={{ $buildTime }}" color="{{ env('WEBAPP_COLOR', '#fbb3a7') }}">
    <style>
        html,
        body,
        div,
        span,
        applet,
        object,
        iframe,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        p,
        blockquote,
        pre,
        a,
        abbr,
        acronym,
        address,
        big,
        cite,
        code,
        del,
        dfn,
        em,
        img,
        ins,
        kbd,
        q,
        s,
        samp,
        small,
        strike,
        strong,
        sub,
        sup,
        tt,
        var,
        b,
        u,
        i,
        center,
        dl,
        dt,
        dd,
        ol,
        ul,
        li,
        fieldset,
        form,
        label,
        legend,
        table,
        caption,
        tbody,
        tfoot,
        thead,
        tr,
        th,
        td,
        article,
        aside,
        canvas,
        details,
        embed,
        figure,
        figcaption,
        footer,
        header,
        hgroup,
        menu,
        nav,
        output,
        ruby,
        section,
        summary,
        time,
        mark,
        audio,
        video {
            margin: 0;
            padding: 0;
            border: 0;
            font-size: 100%;
            font: inherit;
            vertical-align: baseline;
        }

        /* HTML5 display-role reset for older browsers */
        article,
        aside,
        details,
        figcaption,
        figure,
        footer,
        header,
        hgroup,
        menu,
        nav,
        section {
            display: block;
        }

        body {
            line-height: 1;
        }

        ol,
        ul {
            list-style: none;
        }

        blockquote,
        q {
            quotes: none;
        }

        blockquote:before,
        blockquote:after,
        q:before,
        q:after {
            content: '';
            content: none;
        }

        table {
            border-collapse: collapse;
            border-spacing: 0;
        }
    </style>
    <style>
        body {
            font-family: Arial;
        }

        /**
           * Header
           */
        .header {
            background: #0a2667;
        }

        .header div {
            position: relative;
            width: 1200px;
            max-width: 90%;
            padding: 80px 0;
            margin: auto;
        }

        .header td {
            vertical-align: middle;
        }

        .header td:first-child + td {
            width: 80px;
        }

        .header h1 {
            color: #fff;
            font-size: 28px;
            font-weight: 400;
            letter-spacing: 0.05em;
            line-height: 42px;
        }

        .header h1 span {
            font-weight: 700;
        }

        /**
           * Content
           */
        .intro {
            margin: 56px 0;
            text-align: center;
            font-size: 21px;
            font-weight: 700;
            color: #2c3e50;
        }

        .container {
            width: 1200px;
            max-width: 90%;
            margin: auto;
        }

        .group {
            padding: 42px 0;
            border-bottom: 1px solid #979797;
        }

        .group:last-child {
            border-bottom: 0;
        }

        .group .tool {
            display: inline-block;
            width: 25%;
            color: #2f3337;
            text-align: center;
            text-decoration: none;
        }

        .group .tool img {
            display: block;
            margin: auto;
        }

        .group .tool p {
            margin-bottom: 24px;
            font-size: 14px;
            font-weight: 700;
        }

        .error {
            text-align: center;
        }
    </style>
</head>
<body>
<div class="header">
    <div>
        <table cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <img
                        src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAS8AAABDCAYAAADNn4NNAAAAAXNSR0IArs4c6QAAAERlWElmTU0AKgAAAAgAAYdpAAQAAAABAAAAGgAAAAAAA6ABAAMAAAABAAEAAKACAAQAAAABAAABL6ADAAQAAAABAAAAQwAAAABbxOpaAAAiIklEQVR4Ae2dCZhUxbn+ex2GfV9llcUFFRQVRUCWSET0Go1mM5dHTC73r0YNRs010UC8mqt/TUxUwtUYNJioARcEl6jsKouKsoMg27AvA7Pv031/75mu9nTPwjD0zPRA1fO8XXWq6lR99Z1T7/lqOac9HuusBqwGjqmBcDh8l3DMjDZDnWkgUGc12YqsBhq2Blo1bPFPPul9J1+TbIusBqwGTgUNWPI6Fa6ybaPVwEmoATtsPAkvqm2S1UB1NMAcnp98jUGJ1+stqM45yZTHWl7JdDWsLFYDdauBwVT3GngMIutYt1WfeG2WvE5ch7YEq4EGp4GI1fUkgn8b3Al+oEYQ7xUUTnZnySvZr5CVz2qgdjSgKaPTXEUHI+HW+AMhsMbJTmKWvFxXzwatBk4xDYQqaG8P4uaAB0EfCCwlWUnMklcFV89GWQ2cwhoopu3NwH+BmeBW0BUC0+R+UjlLXkl1OawwVgP1roF9SPAvcBQMBE+A/wUjILDmyWSFWfLiqlhnNWA1UKYBtkykE/pP8AD4FMgSuwr8HdwNzoDAzPwYh/XnLHnVn+5tzVYDSakBCCwLTEO4fwcvgj2gPZgCXgDfgcDagXrlj3qtHCVYdxJo4PPPP+++devWcQcOHfjDJ598MvwkaJJtAhqAwDbj6WX028EikAkuAS+CR4BWJZvi14sLfPbZZz/r2bPnAITwZmZmvt+3b99Z9SLJSVzp2rVrO7Zr1+7BQCDQKC8vb8+2bdseHjlyZEl8k/fu3fvzYDB4TigUKt29e/fUQYMGrYnPk4Bj78KFC/0V1V/Tsnv16jW5TZs2t+j84sLi3XhLalqWPS+5NACBadj4FvygIaSu8Y9AHzARXAaeJ202/m7ylrunia81F2jSpMm1dKxvqQa/35+LZ8krweru1KlTqxYtWtyWkpLizcrK2rxjx45HqaLchW7ZsuX3uB6XqnryvYOXMPL64osvLu/YsePVyHD+li1b/oey56ueRLji4mJN8jquWbNmQRO2/smjAYhJ1/gRiGox/h1gBOgPfg/EH0+R9hl+Jnkr2oJBUmJdgApFWMYVmYD1E6cBdFxKadJzM8J5kEi4otJLS0sLFQ8ZeLC+ypFbRedUN+7000+fDDmOVNlFRUXaw5Mwl5+f776HElauLSj5NAAxfcw9vBbJZIHdCM4F48AgMB3MJn0z+TTErFXno/QTfhVgypQpqX//+99bPP74402rK+0dd9zR6MYbb6xs74ifMlPiy5o4cWJQ58XHV3Jcrl1jx451nxv46KOPWjNf06Sy86dOndrsrbfean4cdVZS1DfRXNRvDk4wJH1LvkmTJunl2mM5hzCxrrNSU1MPm8zoWfdAhc60/+abb06tMEMkEtIVOVfLMRQOrlmzpnV2dnZ7+ccqu1qF2kx1qgERE9CE/nigUYQsLu3M/xX4G7gdAusHatcKX7duncazjktPT3+ciqvtvvrqq2Gc8zxzZZ8xzNmGv46b8i3mbn767LPPVkgKzPdcw7zPK0ePHv2EoUzM5O727dtbHTp06EnNve3atet/jCDTpk3rcPjw4ek5OTkLDxw48N7cuXPbmTTjv/vuu+0Pkgc5Zu7Zs2fqo48+2lJpIsh9+/bdhlyzkfVfEGCTr7/++jsczwe7GUL90pQhX52J9P/Iysl6Bzk2gq1gqeT6+OOP+7vzVjd88ODBPoWFhdlSMmV9uX79+nLErLKQfaHyYBmF0a2Wp8s5dX4mx3+UkZHxBjpcn52VvRV/JZixYcOGcfEn0JZzyPs6ZR5S2Vh0xRnol7pmodPX5s2b1899jog6bU/ahNzc3Lnk2QC2cv5ydPcniF5P2XKO63afypYjb4w+TWYRLdf0LuRczPXfhzzZ+AfJ/ym6ncZ1GGPyJqNP0yYLyShbTWSiLY1AGjDunpqUo3MoYDCYDkx5RYRlgY0DtbcqWUPy8jKh/KuCgoJchAvTMTPoCJ9CLtt1LHfkyJH3uNk7xyuEjvxMWY5wmM4W00G5kXtzU4eUnp2T/bI5FyIM0uk/NOfRWb5v0oyflpY2waTTQf7qsig0z+QQtIZiyD2LoZOTFfnzIImLTBmQSic66bumHOr8mnasxrBwohge7a2MVEwZFflx5PVFnz59ZAHKBHPDA5nOU0WVkRdE0xY9z6Idjjzoe9uhw4dW0A6HmDivFKJ+XARn5Ni5c+dQ2r+jpKSkwDmJISznpVFX2v79+2e///77TU3eN954oy3tnxXJJ6JNg1hWU26J4kQ2lHeDyW/8Y5EX90FL5H7TlEvdm7lGbxI3nzL3K54HznE9OE3ddeUj4mShruqr7XpoS8LIS7JSXivwE/AvcATIbQP6YsVw0DzhbaoJeXED/xhhHJeTl7Ng5cqVffr375+ioSM34RQ6u9O7uDnnPPXUU+6hmgfL6Q/mXMhirLtBdKZeEGGW0jOzMme40zZu3PhtOqAYPUwHe4+06HBn5syZfkhmkdLoaNmrVq2KsZB44v9GaXLq+Mjw3OrVq0fTqQaboavkRN7XlQf5S9ZvXP+rGTNmNJUlRnlj6PAOQWCR7MFi7OGW7VhhN3lBNJl09jnocLYBx7PBG5DjYdVfGXlBJFrZcdpAmb+TvqX3xYsXd4P4o6QLQf/CyCQSRz/NIKIlkbIzZEEqjrSAyTdixIgAOnxJeSD3EA+DR1544YVWaj8PmeEQzl6lIWM61/ssc558ZK/S8iL9/+lcOdow5+2339YQQ87Hymc77sHvuuLKUpLsF9EnC0kmVo3FoS0JJS8jCOX2AA+A1aDMSgiH1xP+BegJEjdvcrzkpQ7NjbwSIdTJipcvXz7SCC4fMkiho3+pdHUCbtxvu9NrSl4qlw74SaTeHLZ4nG/KZSvCiJLSMmKDgP5h4o2/efPmaOeCIP9o4t0+wytNZjukCzl+5E5TmKHw/apbTp0xPr2qYzd5lZVQ9W9F5KX2Ep+nM7FWNkM8Ldx1QmDnQ+5OOvrfuWTJkvaudK+GazqXMjKWLl2qpe4Yhw6H0P5C5cFSK7fKSZt/rjQ5wve7T+Y4qt+Kho2k/7HszHAYOV5A9gqHze4yky2M/JOFZJOrpvLQllohL8lD2fqszkjwCtgF5GR46OHYoaYyx58XffLGJ1R2fOGFF/Ziv9LZSqez5PC03uLOO2vWrKInn3zyy6ZNmw4kn5cJ4stJf9+dpyZhlfvYY49NYyl+CHuhmnbr1k0rHV+qrNNOO22C3+cPYjEVM2yaGl8+k4tRtkemlfHpkeOhkldhyvGwneEmn88XlNaJL6LO7q7zznOFjysIsWyFCO9BpBJ045xLfWF0GaZNj9A+vU9WzvXo0eMyZHAm5iGZjRBAljsThPMVpLajefPmZ6H77h26dND81IJInpiFGdoV1Ycpo0OHDpfSTodUJAuW1w9punOs9iNvT5O3VatWMZaXia/Mx9qdR5k/oxw/K57jWWDof+utty4m/2rm79Zzv6zX9a3sfBvfsDTAvRJG4oXcP+vwrwW3gEvBj8Gz4CA4YXfc5MWN35XVKmf1iU5XREfMi5eCjpQFoTjRdDR3p4/PelzHmzZtmsM2g3XshTqHfVM/YC7sMYZNTRs3buzMnVHt/IceemhFVYXSkaLzQe58EINjqaBwT/v27YeSJlToIIeOFSZUIxKdZZ5xxhna1FfOYdFOKhcZiXDrkTZEVwtN/g8++KD04osvzoC8nKhWLVsd1xOO/V/6koDjWrdufR6IzjmaeOOjo64mXB3/pZdeenfChAmT0Os9XKvuXLuLBJ0LmWU/99xza7luvz3rrLM+qE55Nk/D0AAkdghJNdWxC/9tIL6pbIcBScfnjpu8ECSLp2iIpyg85gvQkcsto0ME7nJzjk+kynNfddVVWQxBpvNGwB/gz54cD0FB3Qi3k7XE8GwaT/BqL9u7a6JNDglTnlb93mZ4Mx2ScLfDsciwlrwMjXQxauQo38fKaCNkL4wvAN3G1BeX7n5IxAwZlY83Izxck+j5BbkFx2XJoD/tpHbc4fT0xZkZGX/S9TVx8qVjtR/97HXHHyuMlRgCTzNcfYOHz/mUe7YsRFnRjRo16geG8EB6jaHrqHPPPffzY5V3MqVzzTX/1xkcinT2KptHfl17GQSynjdwjlaTuhFuC4wrIbCLtEwTUVOfslWP6pOcBylTc58aAfQF0XlnwhoJpJGuuqOOvG04UJ+UNSbXkbhW5MsoO/zml3iV1wWofMlf8E1qWYg8aqfKPBBzc6IOU0H8OdFjJr93dO3a9SA3Xif6ShNuRlksMTczT+0e5gRuyjUmLB+BpAzHEYxpaJG/SB3akcHrcUzPSM5vPOp/lR3rd0NYXWnItXQCx8JgIn3lq6++WuMnN7JEh5NMqhdAkG9+U2v9h5irWgWZeuj4Hh4OvbWiyMR5lHDOPvvsZujasYiw0grQx6bKpOb8ctcZQlrLdXPKD/j9RayIJrz9Q4YM2YNMgp7CnhUrVrSFdF+g3muw/PS5FVnQpxR50d7x4DtAw+gp4FhuHBluBbr23wUigX8HKsM4pT0H/mYiTsBvyrnattQbvAL+CERmfwbOtAK+7qd9QCOH7UDzXiKiC8B1QO9DmhHPRMJ9Sdc9sIZ+574XWxI3Geg+/h34CEQd54jY1PZB4PUY8iopLvFqYyIEEWQIE2VVyCrUdEDTvDuvurNwzJgx+7RiBHlNpBOk9uvX70YKWg0cx0rWhaRdpgPmYPaxUvVOWUrZL52vyBxzfj/CH5rjcF54XLBtUMryMDdkGmuSHX/48OH7WNF8uUuXLvcxT3MLjXfIkLm353m6l2PqmJOrOGBFcQGvSW2URdC2bduxDIfHUEcMGWpVFdJsy1B1RRVF1UoS8i1i2LURS/csLJUzWTgZjhzzTWW9e/e+ifhOOkZ387BCN5s0+ejduZ7cAH7aFn2AmDys9i1maLeKazcQDGcu6nrKfMOky2dlsCu66Xbeeectc8djtUaHAlQTDZs8LOp05YHTl5XLZYsWLYpeo8GDB6cj5w6TD92mmfAp5N9AW4cCXbsp4FjuCjIMA7LE/VxPXctuQHOcxokQzjIHJ+hrOuGHkTKWR/zG+KrPkJeiewFZRA554Wte+GEwGohnNALTPahj8YOmDR4Ea4Fx0oG2QTUHS8FHwHG0sxWBu8DPQBOwT4VGSYp5iFu4wa5gu0IqmU28JqxL0/am/ZS8KjDMCuV/M78ymCf9AG7KX7KC14Un9zxu3C7Mdd1GJ2qNpVAEodw3evTonZwTdVgEn9MBnGOsmwdZ5WtDvnRIcBjzId83ZIQslzLMOC3ytI6erwBbAf4K0UykHjVI+6O+ZtvFPxWuxEU7q4Y9FeW5/vrr09ko+XPa+gpytEHGWayM/hOiXCeZmEw/g06tp0grtkpccsEFF0QJu6LyKohzOrUhkQrSZZU6OtdEPnLEyHnddddl8CC4i9d8/in99urVawaLCn/GytrMdRiEBXy75OSBsU2rf3EvXpcqH3Vq0r8Z1+7XrMBqP1dzyvyXyr7zzjuzRo0a9TPKnUV5nbt37/4Sq67XMHG/inxhHmC91X7k78Bet+HM231q2sD2ieg1Jv27XIvlEOtC0sNaJe7br+9f2rRuc+WcOXNWcP2XcL03YGnlUt4IrK6fqByu4Qo2MM8xZZ5CvnlIqy9Wx5l8sq50z+jyLCEYHbUQ1ojmNZAIZ3hAZYUiBR7G/wtw7ulI3F78rxVGHpHa3eDbQMbKIiCSUltFaheDa0EGeX9CG0oJy7nLi05HkUf9fAK4FYi41oNXPOx3msmT8yhcc5QbPBPkghwDhio5ENPWTz/9VOwedVhY3SGt6eIoCo86zivg5lzEvqwx0cyuAHuHUiGFxyHIo9GTCFBOvvZfcQM/QLiEm3nV/Pnz1cgKHXn/lzmYbJAFmU2qMFMkElnupo0ZaidP+purygsxXYj8b9IOZ7+ZkRF5tblzE6uZD2KBOBZOVeW407Bk++Tk5uxT/RDCMs15udNNmLm0d5Qnr6DgKIsTV5p4tw8xDM3IzHgf+ZwNwpKPa+RsFKbslxmK9XPnN2FeherHVpNl6NbZK4fewvkFBflbtm+/3OSRT/sHMN/3GltPdGNFHe0PQTxf05bJ3DMy66MO0m/BFpW3KNrZCMsevYPmftGOfXR2u+4JysxRvcYpTLmHuY+e1YMqWmASBpB5spBo0ShzGZCLsZQrq4d8f3Ny8zIDvmMF4OvPMlq6IMulSkfeam2VIF8XYNyTKpQDWXwtgLvO6D1NfA9geGEh4UGgFWgLLgELgNxO4Iy0IuWew3GmEnAPR+LUtruAs5kZX3vGbgK+AE/vn5OpOR3AsKrOiTo9zblpCy+77LLd0UgCQ4cOTcO75csvv3wopXHKme3btG8JyRVy4++899571zI8EPuXcwxNNGy4d8GCBc8z39EfC6sZ5+Ryg2+49NJLN5LmZciyDML54uqrrz5aroBIBPue7h84cOA0GhFmSOUwfmV52Qz6Im14V3M9WAn7KsuneCyqz/GuEwkwhOyLZdCUc4sgyz3ItWH8+PG5VZ1fURrn7sSCG86wSPutinjHUk+jcg7C+k+svqZKPLJ/f4y+TWYsmo8Jj2VfV3+Gtb1YrWtM58+C7DdzjbaafPH+sGHDNvOKzrdwF3Xu3Lkj03pF6Hwn8ugpFnURi/IGrmtfLLA+lN8CnRVCjBqub7j22muzo5kjAa5jFiu/NwwYMGBw63at2+Vl52XQ5nQlP/3004VgKsFpfOurF9f7dIa/bWUBI3c62HTFFVfoXrKuhhqgi+ZzqlAnLmIpZVVRmR5EItAweJ/8K1150+myT3AsflC/rZAnXPl7EL4HdARfAZHa65RZIV+RZp3VgNWAWwN0uMmCOy4RYcpMhOUlC6hTBJqPOqYj74lYXvoajVYNVaesqZgpDo4HAGfDNP4/wPlAC2w6Rxab6paV1dktaCQu3vIaRrw2j8tKGw8C5pxowERY32rAaqDBaUCrtJdEpP6UDv5KLVsmIh2N2DRHpbm26UBWkXHbCSwFo4EWJNqDbUCLDEfAGvAxMip8LCfrbRf4PVC7opaaJa9jqc6mWw0kvwaGIeL4iJit8WeC2hxWtaH8m0EK0HBVCwZR8oJgNF/8KHGaYugPBoMhQJP/IjyR21zyPEteDR2rcrLq9oJ3yessUpjMlryMJqxvNdBwNfAPRNdcrdxnIGqdODGJ/9lNkb8AIqNMICsrxkE08yAnkdqZ4HTQEmge7FzwY6B5rLPJ82/kNauNRFXodM4T5L2TvGkmhyUvownrWw00XA0sR3Rn60q8dVJLTdJwT4QpV0qdMVYeJKMtEVotl9U0l/Q1xIlrFC+rrScYAy4CLUClC3Okidi0IqmhsSb7H6A8Z9GtLsnLe8sttzTLb9LkNE8jVlUDgXbsnOwNPN5g0Kv3TkLBIC+kBLzhlIA31KSxx5vSOBQOeH2lvlQPm818Jal+3mYOeoA3HPD5eVvaWxBI8ZUG/b5iVq/y/UFfrt/vyw76/cX+oD8U8HmLgv5giM1HPCR4f4C9az7zFgFRaIJtKETmIkYe2i0NBcJ5ZC8MNyG+hacw3NSXz6aVPE+TUA42cgHvLeR7UvEDQPEBkIJ1XHac42mExRzgn6MCoWwqLPEFwgUBvyfkTQl7/FI2tTpXVOHIsbO5S/a3nOJ0xZXP5HEfK547wNmEp7BscPkGkTKdeHaKab6gLC3scerRXaa8lTnWnL0+Mukj1D6dzdJnqBSR9CxXXIgySxyU7fFWgcSHislDPqUTDmv/N+eHQ4XElaWVDWS0lCrjX+cJdeBCvK5Bm0Mdf+X5ZR1UV+dV0JnVwY9lvSRMLurTnREzhIsr/AyOHwG6PbU5dQHnRO4gzx6n2xGJ062o+KrcDhIXgFHgB0CT9yKwuNeDSKlFFy5p3DiFXXUdS0pLoRlfqi8lJT8E2egtyZIUvz8QCHpLA/T1QDDkLSg8LZxf1CGckhLyBEq8sIvXWxjw+INBT9jr84aCKZ4UEV0wEC4JBrx8vsJbSlyYbF7ii8nHC5heSM1TCPGFvH5PETypcjylIrFQOOQtCQW9xTwmCj2NwvlouhjiKcTnGHJKxU8J53ob4VMS8fRMPkcf4kET9pXoSP3VU0In9NNrS7gWXignFNajKIX89Bp6Pr2d7ael7MdSPueK+nSncdUcEtLjSFcQknIeT7riAnmQxuOFkKJkpbyFlBOAhKnE65THsehZLhgJK59DepFjPRudPPKVph/CxomoaJrPiYPoICC2b8PmCIGwzjFChiW4Q2aRBjhCFjnneR2F6JaO5HeIroyowpCh0lWWlKYGoxxHRCNC7fgicPTEBUASV4Nrp7aElErnPJ2CzPNMQm+LdP4Kyyd/ZxK0kdN5WOHrnO2cI+0n3FFfKoX2ALrF5ORnUJ/ZhiQ5+gGsFM+vya8J+41AbRoFBgE5bfTOdUKV/+wn6QEgMhwJfgT06abf6EFdZ27G1KnpVLa4ziqsRkW6uoKWQaw7mTWQtMSlx0i8+zURIgc5Uf0/wAwd4GLy04lFHD8EGlYZp8ZOB6+aiAT7XSlPG1YNwap4fazzPghsF+Ft4E0gS0mEo7bsBuIbWWVtgbjgj+R3Xxi1xbTP8SPp2k7yIGnTgOa/xoPSOiUvKrTOasBqIFYDhyKH7r44lDhZLsZtJWDIy8wPKb86u5w69Ggn9M3POoKJIC892zX0awaMjC0JjwEaIBin5//jQF+DyIdsfkdYA4oRoHcEeA4Zr8d/BnyoCJdTPdr8qrrSXPEKLgMa9muD69lgrBGGsHVWA1YD9aCBp6hzB3DveXqZ405ATgTwhhMq+1GahmWyyAogCngivEBhYJzOmW0OTtDXauJk0Bd8FClLhCsryM0fGt7tAI5DrrXI9RsOBgAR621A1tSzYBb4jDxumYlyvkwxBb8reA9EHXk11/UBESIwEeeaaKINNDwN8BWNFL4Q0YOXrAfz6tKFvL7TLf4/A9Qq/T3a0qVLz+S90fN4bac371ZqhadKx8vX7XjBeyDvLV7CK0Q99YJ1ZSfwnmsX/ryjQ3w65zbiDz566Q9U3Gl8P78xr4edwUvf5/C+ZR+O9SRPakfHmSwkWkjK1Nd6O4OOpmzCHYDeKRSUFtUfYe1u1852xYsMtO6k9wZNfnOOm1hM0VGf/NXaYR8pX58rUrnOfYNvZHbXqVXEco68eg9yMNA8lZx7eFtR/ibk0V61Ch1ppv3VepOgwkJsZP1qAKKaAKnMB5/zYvocSOw9iGAdhPBn/b+lWzoIayIvlRfwKaOP04+kr+Kc1bxgfR/k59z87rz6Mw9esv5rRlbGKvIv3Ld37ztHM45+QdxCyExzK+Uc5c1FnufjE5BrJGXs5yODZ7nTKOdKvn6Rw0vyS3lhexkvpH9J3ru5McvJ4z6vPsPINlmoTxkSWTdtqTZ5nWi91DUQGPIacaLlmfOT9mYxAlq/nAa86UfT/8Qnex7gZew/8dL0cD5Xcx0vaV8NCQyDEKZBJu5JUA+fn0nlEzuH+FbbVV9t+upSiOPZDh07Pjpu3Ljh7tL5E9jT+cjhh7xAnpp5NPN6rKkxnbt0+bf8vPyhfP3huY6dOj4F2dzvPkdhlc8L7OUsM0x9FoeDjVlMjrnPKF7xHl5E/ylfqBhJ8hQ+6fMI1t4N8WXb44atAUhLE/YPAfNAdc+TNezGWemPTwP6lyN95YIh4BXVPRMyuwOS22Hy87maK/Py80vwLzdx8vcf3P9X8q3nm26p7ngTPnj44O25ebm5+uKEiZOPVfcB+Js7TmGsqdHUfZTP+GiCNer4msVVkGGOPtMTifTlF+Qf4O/mpkQzJVmATjhZSDKxaiwObalVy4vyNax9EOgTNiVA7hPQvcZCx51Y5bg4Lq89TAINYHFdjqWyjy+progX58MPP2yJRXM2ltUX7m/k890sttP526Tt3v1Io2CwJedfdOjgwXuY+zITsB4RVotmLS7HcvvwxRdfjJ9IdapasWzFslGjRqXw70EXELHFXT9WlvuwyjDfLHPS+RJubz5s2ZIPWt7EV3wL2J00s8oTbWKD0AAEpXmtO8HFQPNXWol8DkwHe0BCnCWvhKix7grhs2ta/WnNH1Xopshy18z3xy4488wz32Q4NoT4DSbNGbWxYTEULtnXvHmbYZCHj0n2F5nzig4vseaKi0uKj/KZae3BqdDxddWmJPghKq02RR3l+xjCRssyCRAmu3PZiRr5QqwrPuTz+xpBXpNozxHINZ0vul7BZ6E3mzzWb3gagLS0GfVecB3oE2nBZ/iPg4XcB4cjcQnxYuYiElKiLaRWNcCwcTYdvmDEiBG/1WqjuzImx3mhwK9VmJiHEjeNn+39WT279XyGjyzqqZjPZ6Lf0ldtzfn616XDhw7/GfIaywcqNU8R4+bOnduEz3bfD/EtZQJ+uTsRefZQx0DiYuYziO9NfAi5RLhRR5wvVBoqYNh6N5bkjyCx2y1xRdXTIAMQ19UIPgPcCkRc2o/2/8EEMJtrnlDiokzrGqIG+DLst1hZ3MTXTT9i/uh2Pgl9JTfPWMJTsYByWTGMmZMi7yTy7Lntttuaqb36RDNzTl/z2eYZfNLaiVM82yH8zFM9gBW2hcn/x/DHUe5oJukn8pXcxUxfLWS+q6fyuh0T/YOYK9tNnpngWs4ZA2HdyzzYblYh9SSOGVNS3jWQYAHbN7S5skE42jRZaBDCVkNI2pKQOS/K0dzW78A2YNxyAteACrdPVEO8amWJeUJX6wybqd41wL9nz2Ml8DL+vfx7DLm+f/jI4d75ufkZgWBg0ZbtW6565plntrmFZBVvIyO7WVg4zlwWf8Cxa8mSJd9jmPlb5sf0lFyl/LK+wMN8gvstVgR/wjlPBFOCjVltXM+ffkx9/vnn52DtlZsP49+EVjJUHcbTdRKW22OQVmOI8XPIbgJ/rBK/i1qrjLuZm3uZ9Jjhp1tmG05+DUBONyHlfwDNgTYHB8HT4DWwlfuhGN86qwGrgfrUAB11slCfMiSybtpSY8uLc7Vv6yVwABj3OoGhIGrJJ1LeisqylldFWrFxVgNWA+U0ADFpTlNzWreDXqAR2Af+G7wJ9I/a5RZuiK8VZ8mrVtRqC7UaOLk0AHHpHUW9V3gl0Eq33D/B78FaSKvcdIIy1Kaz5FWb2rVlWw00cA1AWkGacAe4DXQDWuHeBfSJmndBel1aW9QXdZa8oqqwAasBqwG3BiCuCznWkFD7BvVStr5k8SLQFghNyBfh15uz5FVvqrcVWw0kpwYgLRGV5rYEfZ5Gc13aQPwwmAsyIa4wfr06S171qn5budVAcmkA4uqARDPBRaAJkHX1FyBrazeklTTbHyx5cUWssxqwGohqoBMh7dsScS0FT4APQF4yWFvIEXWWvKKqsAGrAasBNKAhoj7H/ADQ6z7ZkJbmupLOWfJKuktiBbIaqDMNxLy2Fal1L/4VYFOykpbRjn0x22jC+lYDp5YGZE0ddjVZFpe+AHIAb0OyE5dktZaXtGCd1cAppgHISR8I1Bcf/gvoHdNXjQpIq/eVRCNLVb4lr6q0Y9OsBk5iDUBSeiH/Bw21iXbY2FCvnJXbauAU14Alr1P8BrDNtxpoqBqw5NVQr5yV22rgFNeAJa9T/AawzbcaaKgasBP2DfXKWbnrWgOL6rpCW1/VGvg/eIojNyiZlbYAAAAASUVORK5CYII="
                    />
                </td>

                <td>
                    <span></span>
                </td>

                <td>
                    <h1>
                        {!! \Illuminate\Support\Facades\Lang::getFromJson('desk.internet_explorer.header', [], $user->langcode) !!}
                    </h1>
                </td>
            </tr>
        </table>
    </div>
</div>

<div class="content">
    <p class="intro">{{ \Illuminate\Support\Facades\Lang::getFromJson('desk.internet_explorer.intro', [], $user->langcode) }}</p>

    <div class="container">
        <div id="tools">
            @php ($i = 0)
            @foreach($tools as $tool)
                @if ($i === 0)
                    <div class="group">
                @endif
                    <a class="tool" href="{{ $tool->tools_link }}" target="_blank">
                        <p>{{ $tool->title }}</p>
                        <img src="{{ protected_file_url($tool, 'internet_explorer_logo', true, 'small') ?? protected_file_url($tool, 'logo', true, 'small') }}" width="170">
                    </a>
                @if ($i === 3)
                    </div>
                    @php ($i = -1)
                @endif
                @php ($i++)
            @endforeach
        </div>
    </div>
</div>
</body>
</html>
@endspaceless
