<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateColorFieldForAlerts extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'alerts',
            'background_color',
            [
                'name' => 'background_color',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Couleur du bandeau',
                    'en' => 'Headband colour',
                ],
                'description' => [
                    'fr' => '',
                    'en' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            2
        );
    }
}
