<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class HideBlockFields extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $bridge = new BridgeContentType();
        collect([
          'background_color',
          'dark_mode',
          'icon',
          'open_in_new_tab',
          'link_label'
        ])->each(
            fn ($fieldName) => $bridge->changeFieldFormOptions(
                'blocks',
                $fieldName,
                false,
                'hidden_fields'
            )
        );
        $this->finishUp();
    }
}
