<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateBlocksMigration extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $bridge = new BridgeContentType();
        $bridge->contentTypeUpdateOrCreate('blocks', [], [
          [
            'name' => 'brands',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 7,
            'title' => [
              'fr' => 'Marques',
              'en' => 'Brands',
            ],
            'widget' => [
              'type' => BridgeContentType::SELECT_WIDGET,
              'settings' => [],
              'weight' => 7,
              'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
              'target_type' => ['brands'],
              'cardinality' => -1,
            ],
          ],
          [
            'name' => 'countries',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 8,
            'title' => [
              'fr' => 'Pays',
              'en' => 'Countries',
            ],
            'widget' => [
              'type' => BridgeContentType::SELECT_WIDGET,
              'settings' => [],
              'weight' => 8,
              'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
              'target_type' => ['countries'],
              'cardinality' => -1,
            ],
          ],
          [
            'name' => 'management_modes',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 9,
            'title' => [
              'fr' => 'Modes de gestion',
              'en' => 'Management modes',
            ],
            'widget' => [
              'type' => BridgeContentType::SELECT_WIDGET,
              'settings' => [],
              'weight' => 9,
              'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
              'target_type' => ['management_modes'],
              'cardinality' => -1,
            ],
          ],
          [
            'name' => 'profiles',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 10,
            'title' => [
              'fr' => 'Profils',
              'en' => 'Profiles',
            ],
            'widget' => [
              'type' => BridgeContentType::SELECT_WIDGET,
              'settings' => [],
              'weight' => 10,
              'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
              'target_type' => ['profiles'],
              'cardinality' => -1,
            ],
          ]
        ], [
            [
            'group_name'      => 'group_visibility_rights',
            'entity_type'     => 'node',
            'bundle'          => 'blocks',
            'children'        => [
              'brands',
              'countries',
              'management_modes',
              'profiles',
            ],
            'weight'          => 4,
            'parent_name'     => '',
            'format_settings' => [
              'label'           => 'Rights of visibility',
              'description'     => '',
              'required_fields' => true,
              'id'              => '',
              'classes'         => '',
            ],
            'label'           => 'Rights of visibility',
            'format_type'     => 'fieldset',
          ]
        ]);
    }
}
