<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Comments;
use Inside\Host\Bridge\BridgeContent;

class DeleteSingleComments extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        Comments::select('uuid', 'uuid_host')->each(function ($comment) use ($bridge) {
            if (Comments::where('uuid_host', $comment->uuid_host)->count() === 1) {
                $bridge->contentDelete('comments', $comment->uuid);
            }
        });
    }
}
