<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;

class MakeContentTypesSearchable extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $types = [
            "users",
            "brands",
            "countries",
            "management_modes",
            "profiles",
            "custom",
            "news_types",
            "news_categories",
            "news",
            "contacts_categories",
            "contacts",
            "tools_categories",
            "tools",
            "memorandums",
            "career_infos",
            "regional_offices",
            "regional_office_types",
            "business_units",
            "alerts",
            "pages",
            "forms",
            "lhg_events",
            "events_categories",
            "events",
            "blocks",
        ];

        foreach ($types as $type) {
            $this->getBridge()?->updateContentTypeOptions($type, ['searchable' => true]);
        }

        Artisan::call('index:rebuild');
        $this->finishUp();
    }
}
